% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellwise.R
\docType{class}
\name{cellwise}
\alias{cellwise}
\title{The cellwise logger.}
\format{An \code{R6} class object.}
\usage{
cellwise
}
\description{
The cellwise logger registres the row, column, old, and new value
of cells that changed, along with a step number, timestamp, and the
expression used to alter a dataset. The log is initially written
to a file connection. Upon dump, this file is closed, copied
to a local file and reopened. The connection to the temporary 
file is closed and destroyed when the logger is removed (using
\code{\link{dump_log}(stop=TRUE)} or \code{\link{stop_log}()}.
}
\section{Creating a logger}{

\code{cellwise$new(verbose=TRUE, file=tempfile())}
\tabular{ll}{
\code{verbose}\tab toggle verbosity\cr
 \code{key}\tab \code{[character|integer]} index to column that uniquely identifies a row.\cr
  \code{verbose}\tab \code{[logical]} toggle verbosity.\cr
\code{file}\tab [character] filename for temporaty log storage. \cr
}
}

\section{Dump options}{

\code{$dump(key, verbose=TRUE, file="cellwise.csv")}
\tabular{ll}{
  \code{file}\tab \code{[character]} location to write final output to.
}
}

\section{Details}{

At initialization, the cellwise logger opens a connection to a temporary
file. All logging info is written to that connection. When
\code{\link{dump_log}} is called, the temporary file is closed, copied to the
output file, and reopened for writing. The connection is closed automatically
when the logger is destroyed, for example when calling 
\code{dump_log(stop=TRUE)}, or \code{stop_log()} in the lumberjack pipeline.
}

\examples{
logfile <- tempfile(fileext=".csv")

# convert height from inch to cm and log changes.
# we need to set a unique key.
women$sleutel <- 1:nrow(women)
out <- women \%>>\%
  start_log(log=cellwise$new(key="sleutel")) \%>>\%
  {.$height <- .$height*2.54; .} \%>>\%
  dump_log(file=logfile, stop=TRUE)

read.csv(logfile) \%>>\% head()

}
\seealso{
Other loggers: \code{\link{simple}}
}
\keyword{datasets}
