% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.FigureOfMerit.R
\docType{methods}
\name{plot.FigureOfMerit}
\alias{plot,FigureOfMerit,ANY-method}
\alias{plot.FigureOfMerit}
\title{Plot method for FigureOfMerit objects}
\usage{
\method{plot}{FigureOfMerit}(x, y, ..., from, to,
  col = RColorBrewer::brewer.pal(8, "Set2"), type = "b", key, scales, xlab,
  ylab)

\S4method{plot}{FigureOfMerit,ANY}(x, y, ..., from, to,
  col = RColorBrewer::brewer.pal(8, "Set2"), type = "b", key, scales, xlab,
  ylab)
}
\arguments{
\item{x}{a FigureOfMerit object}

\item{y}{not used}

\item{from}{optional numeric value representing a land use category. If
provided without \code{to} the figure of merit for all transitions from this
category will be plotted}

\item{to}{similar to \code{from}. If provided with a valid \code{from}
argument the transition defined by these two arguments (i.e. \code{from} ->
\code{to}) will be plotted. It is possible to include more than one category
in which case the different transitions will be included on the same plot}

\item{col}{character specifying the plotting colour. Default is to use the
'Set2' palette from \code{RColorBrewer}}

\item{type}{character. See \code{lattice::\link[lattice]{panel.xyplot}}}

\item{key}{list. See \code{lattice::\link[lattice]{xyplot}}}

\item{scales}{list. See \code{lattice::\link[lattice]{xyplot}}}

\item{xlab}{character or expression. See \code{lattice::\link[lattice]{xyplot}}}

\item{ylab}{character or expression. See \code{lattice::\link[lattice]{xyplot}}}

\item{\dots}{additional arguments to \code{lattice::\link[lattice]{xyplot}}}
}
\value{
A trellis object.
}
\description{
Plot the overall, category-specific or transition-specific figure of merit at
different resolutions.
}
\examples{
## see lulcc-package examples
}
\seealso{
\code{\link{FigureOfMerit}}, \code{lattice::\link[lattice]{xyplot}},
  \code{lattice::\link[lattice]{panel.xyplot}}
}

