% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_image_import_array.R
\name{l_image_import_array}
\alias{l_image_import_array}
\title{Import Greyscale Images as Tcl images from an Array}
\usage{
l_image_import_array(
  array,
  width,
  height,
  img_in_row = TRUE,
  invert = FALSE,
  rotate = 0
)
}
\arguments{
\item{array}{of 0-255 grayscale value data.}

\item{width}{of images in pixels.}

\item{height}{of images in pixels.}

\item{img_in_row}{logical, TRUE if every row of the array represents an image}

\item{invert}{logical, for 'invert=FALSE' 0=withe, for 'invert=TRUE' 0=black}

\item{rotate}{the image: one of 0, 90, 180, or 270 degrees.}
}
\value{
vector of image object names
}
\description{
Import image grayscale data (0-255) with each image saved as a
  row or column of an array.
}
\details{
Images in tcl are managed by the tcl interpreter and made accessible
  to the user via a handle, i.e. a function name of the form image1, image2, 
  etc.

For more information run: \code{l_help("learn_R_display_plot.html#images")}
}
\examples{

\dontrun{
# see
demo("l_ng_images_frey_LLE")
}
}
