% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_polygons}
\alias{l_layer_polygons}
\title{Layer a polygons}
\usage{
l_layer_polygons(widget, x, y, color = "gray80", linecolor = "black",
  linewidth = 1, label = "polygons", parent = "root", index = 0, ...)
}
\arguments{
\item{widget}{widget path name as a string}

\item{x}{list with vectors with x coordinates}

\item{y}{list with vectors with y coordinates}

\item{color}{vector with fill colors, if empty string \code{""}, then the
fill is transparant}

\item{linecolor}{vector with outline colors}

\item{linewidth}{vector with line widths}

\item{label}{label used in the layers inspector}

\item{parent}{group layer}

\item{index}{of the newly added layer in its parent group}

\item{...}{additional state initialization arguments, see 
\code{\link{l_info_states}}}
}
\value{
layer object handle, layer id
}
\description{
Loon's displays that are based on Cartesian coordinates (i.e.
  scatterplot, histogram and graph display) allow for layering visual
  information including polygons, text and rectangles.
}
\details{
For more information run: \code{l_help("learn_R_layer")}
}
\examples{

p <- l_plot()

l <- l_layer_polygons(
     p,
     x = list(c(1,2,1.5), c(3,4,6,5,2), c(1,3,5,3)),
     y = list(c(1,1,2), c(1,1.5,1,4,2), c(3,5,6,4)),
     color = c('red', 'green', 'blue'),
     linecolor = ""
)
l_scaleto_world(p)

l_info_states(l, "color")
}
\seealso{
\code{\link{l_layer}}, \code{\link{l_info_states}}
}
