% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_delete}
\alias{l_layer_delete}
\title{Delete a layer}
\usage{
l_layer_delete(widget, layer)
}
\arguments{
\item{widget}{widget path or layer object of class \code{'l_layer'}}

\item{layer}{layer id. If the widget argument is of class \code{'l_layer'}
then the layer argument is not used}
}
\value{
0 if success otherwise the function throws an error
}
\description{
All but the \code{'model'} and the \code{'root'} layer can be 
  dynamically deleted. If a group layer gets deleted with
  \code{l_layer_delete} then all its children layers get moved into their
  grandparent group layer.
}
\examples{
p <- l_plot()
l1 <- l_layer_rectangle(p, x = 0:1, y = 0:1, color='red')
l_layer_delete(l1)

l2 <- l_layer_rectangle(p, x = 0:1, y = 0:1, color='yellow')
l_layer_delete(p,l2)
}
\seealso{
\code{\link{l_layer}}, \code{\link{l_info_states}}
}
