% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rp.R
\name{lol.project.rp}
\alias{lol.project.rp}
\title{Random Projections (RP)}
\usage{
lol.project.rp(X, r, scale = TRUE, ...)
}
\arguments{
\item{X}{\code{[n, d]} the data with \code{n} samples in \code{d} dimensions.}

\item{r}{the rank of the projection. Note that \code{r >= K}, and \code{r < d}.}

\item{scale}{whether to scale the random projection by the sqrt(1/d). Defaults to \code{TRUE}.}

\item{...}{trailing args.}
}
\value{
A list containing the following:
\item{\code{A}}{\code{[d, r]} the projection matrix from \code{d} to \code{r} dimensions.}
\item{\code{Xr}}{\code{[n, r]} the \code{n} data points in reduced dimensionality \code{r}.}
}
\description{
A function for implementing gaussian random projections (rp).
}
\section{Details}{

For more details see the help vignette:
\code{vignette("rp", package = "lolR")}
}

\examples{
library(lolR)
data <- lol.sims.rtrunk(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
model <- lol.project.rp(X=X, r=5)  # use lol to project into 5 dimensions
}
\author{
Eric Bridgeford
}
