% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logr.R
\name{log_print}
\alias{log_print}
\alias{put}
\alias{sep}
\alias{log_hook}
\title{Print an object to the log}
\usage{
log_print(x, ..., console = TRUE, blank_after = NULL, msg = FALSE, hide_notes = FALSE)

put(x, ..., console = TRUE, blank_after = NULL, msg = FALSE, hide_notes = FALSE)

sep(x, console = TRUE)

log_hook(x)
}
\arguments{
\item{x}{The object to print.}

\item{...}{Any parameters to pass to the print function.}

\item{console}{Whether or not to print to the console.  Valid values are
TRUE and FALSE.  Default is TRUE.}

\item{blank_after}{Whether or not to print a blank line following the
printed object.  The blank line helps readability of the log.  Valid values
are TRUE and FALSE. Default is TRUE.}

\item{msg}{Whether to print the object to the msg log.  This parameter is
intended to be used internally.  Value values are TRUE and FALSE.  The
default value is FALSE.}

\item{hide_notes}{If notes are on, this parameter gives you the option
of not printing notes for a particular log entry.  Default is FALSE,
meaning notes will be displayed.  Used internally.}
}
\value{
The object, invisibly
}
\description{
The \code{log_print} function prints an object to the currently opened log.
}
\details{
The log is initialized with \code{log_open}.  Once the log is open, objects
like variables and data frames can be printed to the log to monitor execution
of your script.  If working interactively, the function will print both to
the log and to the console.  The \code{log_print} function is useful when
writing and debugging batch scripts, and in situations where some record
of a scripts' execution is required.

If requested in the \code{log_open} function, \code{log_print}
will print a note after each call.  The note will contain a date-time stamp
and elapsed time since the last call to \code{log_print}.  When printing
a data frame, the \code{log_print} function will also print the number
and rows and column in the data frame.  These counts may also be useful
in debugging.

Notes may be turned off either by setting the \code{show_notes} parameter
on \code{log_open} to FALSE, or by setting the global option "logr.notes"
to FALSE.

The \code{put} function is a shorthand alias for \code{log_print}. You can
use \code{put} anywhere you would use \code{log_print}.  The functionality
is identical.

The \code{sep} function is also a shorthand alias for \code{log_print},
except it will print a separator before and after the printed text.  This
function is intended for documentation purposes, and you can use it
to help organize your log into sections.

The \code{log_hook} function is for other packages that wish to
integrate with \strong{logr}.  The function prints to the log only if
\code{autolog} is enabled. It will not print to the console.
}
\examples{
# Create temp file location
tmp <- file.path(tempdir(), "test.log")

# Open log
lf <- log_open(tmp)

# Send message to log
log_print("High Mileage Cars Subset")

# Perform operations
hmc <- subset(mtcars, mtcars$mpg > 20)

# Print data to log
log_print(hmc)

# Close log
log_close()

# View results
writeLines(readLines(lf))
}
\seealso{
\code{\link{log_open}} to open the log,
and \code{\link{log_close}} to close the log.
}
