% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cars_china}
\alias{cars_china}
\title{Stated car choice observations by Chinese car buyers}
\format{
\tabular{ll}{
   Variable \tab Description \cr
   \code{id} \tab individual identifiers \cr
   \code{obsnum} \tab identifier for unique choice observation \cr
   \code{choice} \tab dummy code for choice (\code{1} or \code{0}) \cr
   \code{hev} \tab dummy code for HEV vehicle type (\code{1} or \code{0}) \cr
   \code{phev10} \tab dummy code for PHEV vehicle type w/10 mile electric driving range (\code{1} or \code{0}) \cr
   \code{phev20} \tab dummy code for PHEV vehicle type w/20 mile electric driving range (\code{1} or \code{0}) \cr
   \code{phev40} \tab dummy code for PHEV vehicle type w/40 mile electric driving range (\code{1} or \code{0}) \cr
   \code{bev75} \tab dummy code for BEV vehicle type w/75 mile electric driving range (\code{1} or \code{0}) \cr
   \code{bev100} \tab dummy code for BEV vehicle type w/100 mile electric driving range (\code{1} or \code{0}) \cr
   \code{bev150} \tab dummy code for BEV vehicle type w/150 mile electric driving range (\code{1} or \code{0}) \cr
   \code{phevFastcharge} \tab dummy code for whether PHEV vehicle had fast charging capability (\code{1} or \code{0}) \cr
   \code{bevFastcharge} \tab dummy code for whether BEV vehicle had fast charging capability (\code{1} or \code{0}) \cr
   \code{price} \tab price of vehicle ($USD) \cr
   \code{opCost} \tab operating cost of vehicle (US cents / mile) \cr
   \code{accelTime} \tab 0-60 mph acceleration time (seconds) \cr
   \code{american} \tab dummy code for whether American brand (\code{1} or \code{0}) \cr
   \code{japanese} \tab dummy code for whether Japanese brand (\code{1} or \code{0}) \cr
   \code{chinese} \tab dummy code for whether Chinese brand (\code{1} or \code{0}) \cr
   \code{skorean} \tab dummy code for whether S. Korean brand (\code{1} or \code{0}) \cr
   \code{weights} \tab weights for each individual computed so that the sample age and income demographics matched with those of the general car-buying population \cr
}
}
\source{
Raw data downloaded from \href{https://github.com/jhelvy/tra2015}{this repo}
}
\usage{
data(cars_china)
}
\description{
Data from Helveston et al. (2015) containing 448 stated choice observations
from Chinese car buyers and 384 stated choice observations from US car
buyers. Conjoint surveys were fielded in 2012 in four major Chinese cities
(Beijing, Shanghai, Shenzhen, and Chengdu), online in the US on Amazon
Mechanical Turk, and in person at the Pittsburgh Auto show. Participants
were asked to select a vehicle from a set of three alternatives. Each
participant answered 15 choice questions.
}
\examples{
data(cars_china)

head(cars_china)
}
\references{
Helveston, J. P., Liu, Y., Feit, E. M., Fuchs, E. R. H.,
Klampfl, E., & Michalek, J. J. (2015). "Will Subsidies Drive Electric
Vehicle Adoption? Measuring Consumer Preferences in the U.S. and China."
Transportation Research Part A: Policy and Practice, 73, 96–112.
\doi{10.1016/j.tra.2015.01.002}
}
\keyword{datasets}
