% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistf.control.R
\encoding{UTF-8}
\name{logistf.control}
\alias{logistf.control}
\title{Control Parameters for \code{logistf}}
\usage{
logistf.control(
  maxit = 25,
  maxhs = 5,
  maxstep = 5,
  lconv = 1e-05,
  gconv = 1e-05,
  xconv = 1e-05,
  collapse = TRUE
)
}
\arguments{
\item{maxit}{The maximum number of iterations}

\item{maxhs}{The maximum number of step-halvings in one iteration. The increment of the 
beta vector within one iteration is divided by 2 if the new beta leads to a decrease 
in log likelihood.}

\item{maxstep}{Specifies the maximum step size in the beta vector within one iteration.}

\item{lconv}{Specifies the convergence criterion for the log likelihood.}

\item{gconv}{Specifies the convergence criterion for the first derivative of the log likelihood (the score vector).}

\item{xconv}{Specifies the convergence criterion for the parameter estimates.}

\item{collapse}{If \code{TRUE}, evaluates all unique combinations of x and y and collapses data set.}
}
\value{
\item{maxit}{The maximum number of iterations}
   \item{maxhs}{The maximum number of step-halvings in one iteration. The increment of the 
beta vector within one iteration is divided by 2 if the new beta leads to a decrease 
in log likelihood.}
   \item{maxstep}{Specifies the maximum step size in the beta vector within one iteration.}
   \item{lconv}{Specifies the convergence criterion for the log likelihood.}
   \item{gconv}{Specifies the convergence criterion for the first derivative of the log likelihood (the score vector).}
   \item{xconv}{Specifies the convergence criterion for the parameter estimates.}
   \item{collapse}{If \code{TRUE}, evaluates all unique combinations of x and y and collapses data set.}
}
\description{
Sets parameters for Newton-Raphson iteration in Firth's penalized-likelihood logistic regression.
}
\details{
\code{logistf.control()} is used by \code{logistf} and \code{logistftest} to set control parameters to default values. 
Different values can be specified, e. g., by \code{logistf(..., control= logistf.control(maxstep=1))}.
}
\examples{
data(sexagg)
fit2<-logistf(case ~ age+oc+vic+vicl+vis+dia, data=sexagg, weights=COUNT, 
    control=logistf.control(maxstep=1))
summary(fit2)

}
\author{
Georg Heinze
}
