% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logic.boosting.R
\name{logicDT.boosting}
\alias{logicDT.boosting}
\alias{logicDT.boosting.default}
\alias{logicDT.boosting.formula}
\title{Fitting boosted logicDT models}
\usage{
\method{logicDT.boosting}{default}(
  X,
  y,
  Z = NULL,
  boosting.iter = 500,
  learning.rate = 0.01,
  subsample.frac = 1,
  replace = TRUE,
  line.search = "min",
  ...
)

\method{logicDT.boosting}{formula}(formula, data, ...)
}
\arguments{
\item{X}{Matrix or data frame of binary predictors coded as 0 or 1.}

\item{y}{Response vector. 0-1 coding for binary responses.
Otherwise, a regression task is assumed.}

\item{Z}{Optional matrix or data frame of quantitative/continuous
covariables. Multiple covariables allowed for splitting the trees.
If four parameter logistic models shall be fitted in the leaves,
only the first given covariable is used.}

\item{boosting.iter}{Number of boosting iterations}

\item{learning.rate}{Learning rate for boosted models.
Values between 0.001 and 0.1 are recommended.}

\item{subsample.frac}{Subsample fraction for each
boosting iteration. E.g., 0.5 means that are random draw
of 50% of the original training data observations
is used in each iteration.}

\item{replace}{Should the random draws with subsample.frac
in boosted models be performed with or without
replacement? TRUE or FALSE}

\item{line.search}{Type of line search for gradient boosting.
"min" performs a real minimization while "binary" performs
a loose binary search for a boosting coefficient that
just reduces the score.}

\item{...}{Arguments passed to \code{logicDT}}

\item{formula}{An object of type \code{formula} describing the
model to be fitted.}

\item{data}{A data frame containing the data for the corresponding
\code{formula} object. Must also contain quantitative covariables
if they should be included as well.}
}
\value{
An object of class \code{logic.boosted}. This is a list
  containing
  \item{\code{models}}{A list of fitted logicDT models}
  \item{\code{rho}}{A vector of boosting coefficient corresponding
  to each model}
  \item{\code{initialModel}}{Initial model which is usually the
  observed mean}
  \item{\code{...}}{Supplied parameters of the functional call
    to \code{\link{logicDT.boosting}}.}
}
\description{
Function for fitting gradient boosted logicDT models.
}
\details{
Details on single logicDT models can be found in \code{\link{logicDT}}.
}
\references{
\itemize{
  \item Lau, M., Schikowski, T. & Schwender, H. (2021).
  logicDT: A Procedure for Identifying Response-Associated
  Interactions Between Binary Predictors. To be submitted.
  \item Friedman, J. H. (2001).
  Greedy Function Approximation: A Gradient Boosting Machine.
  The Annals of Statistics, 29(5), 1189–1232.
  \doi{https://doi.org/10.1214/aos/1013203451}
}
}
