% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqGPutils.R
\name{splitDoE}
\alias{splitDoE}
\title{Training/test data generator according to a given Design of Experiment (DoE)}
\usage{
splitDoE(
  x,
  y,
  DoE.idx = NULL,
  DoE.type = c("rand", "regs"),
  ratio = 0.3,
  seed = NULL
)
}
\arguments{
\item{x}{a vector (or matrix) with the input locations.}

\item{y}{a vector with the output observations.}

\item{DoE.idx}{the numeric indices of the training data used in the design.}

\item{DoE.type}{if \code{is.null(DoE.idx)}, a character string
corresponding to the type of DoE.
Options: \code{rand} (random desings), \code{regs} (regular-spaced desings).}

\item{ratio}{if \code{is.null(DoE.idx)}, a number with the ratio
nb_train/nb_total (by default, ratio = 0.3).}

\item{seed}{an optional value corresponding to the seed for random methods.}
}
\value{
A list with the DoE: \code{list(xdesign, ydesign, xtest, ytest)}.
}
\description{
Split the data in training/test sets according to a given DoE.
}
\section{Comments}{

This function is in progress. Other types of DoEs will be considered using
the \code{DiceDesign} package.
}

\examples{
# generating the toy example
x <- seq(0, 1, length = 100)
y <- sin(4*pi*x)

# regular DoE
DoE <- splitDoE(x, y, DoE.type = "regs", ratio = 0.3)
plot(x,y)
points(DoE$xdesign, DoE$ydesign, col = "red", pch = 20)
points(DoE$xtest, DoE$ytest, col = "blue", pch = 20)
legend("topright", c("training data", "test data"),
       pch = rep(20, 2), col = c("red", "blue"))

# random DoE
DoE <- splitDoE(x, y, DoE.type = "rand", ratio = 0.3, seed = 1)
plot(x,y)
points(DoE$xdesign, DoE$ydesign, col = "red", pch = 20)
points(DoE$xtest, DoE$ytest, col = "blue", pch = 20)
legend("topright", c("training data", "test data"),
       pch = rep(20, 2), col = c("red", "blue"))

}
\author{
A. F. Lopez-Lopera.
}
