% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqAGP.R
\name{create.lineqAGP}
\alias{create.lineqAGP}
\title{Creation Method for the \code{"lineqAGP"} S3 Class}
\usage{
\method{create}{lineqAGP}(x, y, constrType)
}
\arguments{
\item{x}{a vector or matrix with the input data. The dimensions should be indexed by columns.}

\item{y}{a vector with the output data.}

\item{constrType}{a character string corresponding to the type of the inequality constraint.
Options: "boundedness", "monotonicity", "convexity", "linear";
Multiple constraints can be also defined, e.g. \code{constrType = c("boundedness", "monotonicity")}.}
}
\value{
A list with the following elements.
\item{x,y,constrType}{see \bold{Arguments}.}
\item{d}{a number corresponding to the input dimension.}
\item{constrIdx}{for d > 1, a integer vector with the indices of active constrained dimensions.}
\item{constrParam}{constraint inequalities for each dimension.}
\item{varnoise}{a scalar with noise variance.}
\item{localParam}{a list with specific parameters required for \code{"lineqAGP"} models:
\code{m} (number of basis functions), \code{sampler}, and \code{samplingParams}.
See \code{\link{simulate.lineqAGP}}.}
\item{kernParam}{a list with the kernel parameters: \code{par} (kernel parameters), \code{type}, \code{nugget}.
See \code{\link{kernCompute}}}
\item{bounds}{the limit values if \code{constrType = "boundedness"}.}
\item{(Lambda,lb,ub)}{the linear system of inequalities if \code{constrType = "linear"}.}
}
\description{
Creation method for the \code{"lineqAGP"} S3 class.
}
\examples{
# creating the model
d <- 2
fun1 <- function(x) return(4*(x-0.5)^2)
fun2 <- function(x) return(2*x)
targetFun <- function(x) return(fun1(x[, 1]) + fun1(x[, 2])) 
xgrid <- expand.grid(seq(0, 1, 0.01), seq(0, 1, 0.01))
ygrid <- targetFun(xgrid)
xdesign <- rbind(c(0.5, 0), c(0.5, 0.5), c(0.5, 1), c(0, 0.5), c(1, 0.5))
ydesign <- targetFun(xdesign)
model <- create(class = "lineqAGP", x = xdesign, y = ydesign,
                constrType = c("convexity", "monotonicity"))
str(model)

}
\references{
Lopez-Lopera, A. F., Bachoc, F., Durrande, N., and Roustant, O. (2017),
"Finite-dimensional Gaussian approximation with linear inequality constraints".
\emph{ArXiv e-prints}
\href{https://arxiv.org/abs/1710.07453}{[link]}
}
\seealso{
\code{\link{augment.lineqAGP}}, \code{\link{predict.lineqAGP}}, \code{\link{simulate.lineqAGP}}
}
\author{
A. F. Lopez-Lopera.
}
