% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{k1matern32}
\alias{k1matern32}
\title{1D Matern 3/2 Kernel Matrix for \code{"lineqGP"} Models.}
\usage{
k1matern32(x1, x2, par, d = 1)
}
\arguments{
\item{x1}{a vector with the first input locations.}

\item{x2}{a vector with the second input locations.}

\item{par}{the values of the kernel parameters (variance, lengthscale).}

\item{d}{a number corresponding to the dimension of the input space.}
}
\value{
Kernel matrix \eqn{K(x_1,x_2)}{K(x1,x2)}
(or \eqn{K(x_1,x_1)}{K(x1,x1)} if \eqn{x_2}{x2} is not defined).
}
\description{
Compute the 1D Matern 3/2 kernel for \code{"lineqGP"} models.
attr: "gradient", "derivative".
}
\examples{
x <- seq(0, 1, 0.01)
K <- k1matern32(x, x, par =  c(1, 0.1))
image(K, main = "covariance matrix using a Matern 3/2 kernel")

}
\author{
A. F. Lopez-Lopera.
}
