% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_tags.R
\name{validate_tags}
\alias{validate_tags}
\title{Checks the tags of a linelist object}
\usage{
validate_tags(x, allow_extra = FALSE)
}
\arguments{
\item{x}{a \code{linelist} object}

\item{allow_extra}{a \code{logical} indicating if additional data tags not
currently recognized by \code{linelist} should be allowed; if \code{FALSE}, unknown
tags will trigger an error}
}
\value{
If checks pass, a \code{linelist} object; otherwise issues an error.
}
\description{
This function evalutes the validity of the tags of a \code{linelist} object by
checking that: i) tags are present ii) tags is a \code{list} of \code{character} iii)
that all default tags are present iv) tagged variables exist v) that no extra
tag exists (if \code{allow_extra} is \code{FALSE}).
}
\examples{
if (require(outbreaks) && require(dplyr) && require(magrittr)) {

  ## create a valid linelist
  x <- measles_hagelloch_1861 \%>\%
    tibble() \%>\% 
    make_linelist(id = "case_ID",
                  date_onset = "date_of_prodrome",
                  age = "age",
                  gender = "gender")
  x

  ## validation
  validate_tags(x)

  ## hack to create an invalid tags (missing defaults)
  attr(x, "tags") <- list(id = "case_ID")

  ## the below issues an error
  ## note: tryCatch is only used to avoid a genuine error in the example 
  tryCatch(validate_tags(x), error = paste)
}
}
\seealso{
\code{\link[=validate_types]{validate_types()}} to check if tagged variables have
the right classes
}
\author{
Thibaut Jombart \email{thibaut@data.org}
}
