% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_eq_nestIfs.R
\name{ls_eq_nestIfs}
\alias{ls_eq_nestIfs}
\title{Create a series of nested LSEM \code{if} equations}
\usage{
ls_eq_nestIfs(conditions, values, elseExpr, quoteValues = FALSE)
}
\arguments{
\item{conditions}{The conditions - in the right order, i.e. in the
produced expression if nested if statements, the first condition in this
list will be checked first, then the second, etc.}

\item{values}{The values corresponding to each condition (in the
same order!).}

\item{elseExpr}{The value to return if there are no matches.}

\item{quoteValues}{Whether to use double quotes to quote the values.}
}
\value{
A character value.
}
\description{
This function takes a series of conditions and corresponding values,
and builds an equation consisting of nested if statements.
}
\examples{
### Relatively simple example with four levels of nesting
ls_eq_nestIfs(c("age.NAOK > 80",
                "age.NAOK > 65",
                "age.NAOK > 40",
                "age.NAOK > 20"),
              c("Respectable",
                "Roughly retired",
                "Roughly middle-aged",
                "Quite young"),
              "Very young",
              quoteValue=TRUE);
}
