% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_transform.R
\name{st_transform}
\alias{st_transform}
\alias{st_transform.LAS}
\title{Transform or convert coordinates of LAS objects}
\usage{
\method{st_transform}{LAS}(x, crs, ...)
}
\arguments{
\item{x, }{An object of class LAS}

\item{crs}{crs object from sf or CRS object from sp}

\item{...}{additional arguments \code{scale} and \code{xoffset}, \code{yoffset}, \code{zoffset}
for the output LAS objects. It is not  mandatory but recommended to consider providing such
information. Otherwise it will be guessed automatically which might not be the best choice.}
}
\value{
A LAS object
}
\description{
Transform or convert coordinates of LAS objects  \code{st_transform()} extends \code{sf::st_transform()}
}
\examples{
LASfile <- system.file("extdata", "example.laz", package="rlas")
las = readLAS(LASfile)
st_crs(las)$Name
st_bbox(las)
tlas <- sf::st_transform(las, sf::st_crs(26918))
st_crs(tlas)$Name
st_bbox(tlas)
}
