% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_metrics3d.r
\name{grid_metrics3d}
\alias{grid_metrics3d}
\title{Voxelize the space and compute metrics for each voxel}
\usage{
grid_metrics3d(.las, func, res = 1, debug = FALSE)
}
\arguments{
\item{.las}{An object of class \code{LAS}}

\item{func}{the function to be apply to each voxel.}

\item{res}{numeric. The size of the voxels}

\item{debug}{logical. If you encouter a non trivial error try \code{debug = TRUE}.}
}
\value{
It returns a \code{data.table} containing the metrics for each voxel. The table
has the class \code{lasmetrics3d} enabling easier plotting.
}
\description{
Voxelize the cloud of points and compute a series of descriptive statistics for
each voxel.
}
\details{
Voxelize creates a 3D matrix of voxels with a given resolution. It creates a voxel
from the cloud of points if there is at least one point in the voxel. For each voxel
the function allows computation of one or several derived metrics in the same way as
the \link[lidR:grid_metrics]{grid_metrics} functions.
Basically there are no predefined metrics. Users must write their own function to create metrics.
Voxelize will dispatch the LiDAR data for each voxel in the user's function. The user writes their
function without considering voxels, only a cloud of points (see example).
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

# Cloud of points is voxelized with a 1-meter resolution and in each voxel
# the number of points is computed.
grid_metrics3d(lidar, length(Z))

# Cloud of points is voxelized with a 1-meter resolution and in each voxel
# the mean scan angle of points is computed.
grid_metrics3d(lidar, mean(ScanAngle))

# Define your own metric function
myMetrics = function(i, angle, pulseID)
{
  ret = list(
     npulse  = length(unique(pulseID)),
     angle   = mean(angle),
     imean   = mean(i)
   )

   return(ret)
}

voxels = grid_metrics3d(lidar, myMetrics(Intensity, ScanAngle, pulseID))

plot(voxels, "angle")
plot(voxels, "imean")
#etc.
}
\seealso{
\link[lidR:grid_metrics]{grid_metrics}
}
