% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_canopy.r
\name{grid_canopy}
\alias{grid_canopy}
\title{Canopy surface model}
\usage{
grid_canopy(.las, res = 2, subcircle = 0)
}
\arguments{
\item{.las}{An object of class \code{LAS}}

\item{res}{numeric. The size of a grid cell in LiDAR data coordinates units. Default is
2 meters i.e. 4 square meters.}

\item{subcircle}{numeric radius of the circles. To fill empty pixels the algorithm
replaces each return by a circle composed of 8 points before computing the maximum elevation
in each pixel.}
}
\value{
It returns a \code{data.table} with the class \code{lasmetrics} which enables easier plotting and
RasterLayer casting.
}
\description{
Creates a canopy surface model using a LiDAR point cloud. For each pixel the
function returns the highest point found. This basic method could be improved by replacing
each LiDAR return with a small disk.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

# Local maximum algorithm with a resolution of 2 meters
lidar \%>\% grid_canopy(2) \%>\% plot

# Local maximum algorithm with a resolution of 1 meters
lidar \%>\% grid_canopy(1) \%>\% plot

# Local maximum algorithm with a resolution of 1 meters replacing each
# point by a 20 cm radius circle of 8 points
lidar \%>\% grid_canopy(1, 0.2) \%>\% plot
}
\seealso{
\link[lidR:grid_metrics]{grid_metrics}
\link[lidR:as.raster.lasmetrics]{as.raster}

Other grid_alias: \code{\link{grid_density}}
}

