#' Loughran-McDonald Modal List
#'
#' A dataset containing a character vector of Loughran & McDonald's (2016)
#' modal list.  Wikipedia states: "A modal verb is a type of verb that is used
#' to indicate modality - that is: likelihood, ability, permission and obligation."
#'
#' @details
#' \itemize{
#'   \item modal.
#'   \item strength.
#' }
#'
#' @docType data
#' @keywords datasets
#' @name modal_loughran_mcdonald
#' @usage data(modal_loughran_mcdonald)
#' @format A data frame with 61 rows and 2 variables
#' @references Loughran, T. and McDonald, B. (2016). Textual analysis in
#' accounting and finance: A survey. Journal of Accounting Research 54(4),
#' 1187-1230. doi: 10.2139/ssrn.2504147 \cr \cr
#' \url{https://sraf.nd.edu/textual-analysis/resources/#Master\%20Dictionary}
NULL
