% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key-range.R
\name{key_range}
\alias{key_range}
\alias{key_range_auto}
\alias{key_range_manual}
\alias{key_range_map}
\title{Range keys}
\usage{
key_range_auto(sep = "[^[:alnum:]]+", reverse = FALSE, ...)

key_range_manual(start, end, name = NULL, level = NULL, ...)

key_range_map(data, ..., .call = caller_env())
}
\arguments{
\item{sep}{A \verb{<character[1]>} giving a \link[base:regex]{regular expression} to
use for splitting labels provided by the scale using
\code{\link[base:strsplit]{strsplit()}}. Defaults to splitting on any
non-alphanumeric character.}

\item{reverse}{A \verb{<logical[1]>} which if \code{FALSE} (default) treats the first
labels as the inner labels and the last labels as the outer labels.
If \code{TRUE}, thee first labels are treated as the outer labels and the last
labels are treated as the inner labels.}

\item{...}{\code{\link[rlang:topic-data-mask]{<data-masking>}} A set of mappings
similar to those provided to \code{\link[ggplot2:aes]{aes()}}, which will be
evaluated in the \code{data} argument.
For \code{key_range_map()}, these \emph{must} contain \code{start} and \code{end} mappings.
Can contain additional parameters for text styling, namely \code{colour},
\code{family}, \code{face}, \code{size}, \code{hjust}, \code{vjust}, \code{angle} and \code{lineheight}.}

\item{start, end}{A vector that can be interpreted by the scale, giving the
start and end positions of each range respectively.}

\item{name}{A \verb{<character>} or list of expressions}

\item{level}{An \verb{<integer>} giving the depth of each range to avoid overlaps
between different ranges. When \code{level} is smaller than 1, no brackets are
drawn.}

\item{data}{A \verb{<data.frame>} or similar object coerced by
\code{\link[ggplot2:fortify]{fortify()}} to a \verb{<data.frame>}, in which the \code{mapping}
argument is evaluated.}

\item{.call}{A \link[rlang:topic-error-call]{call} to display in messages.}
}
\value{
For \code{key_range_auto()} a function. For \code{key_range_manual()} and
\code{key_range_map()} a \verb{<data.frame>} with the \verb{<key_range>} class.
}
\description{
These functions are helper functions for working with ranged data as keys
in guides. They all share the goal creating of a guide key, but have
different methods:
\itemize{
\item \code{key_range_auto()} is a function factory whose functions make an attempt
to infer ranges from the scale's labels.
\item \code{key_range_manual()} uses user-provided vectors to set ranges.
\item \code{key_range_map()} makes mappings from a \verb{<data.frame>} to set ranges.
}
}
\details{
The \code{level} variable is optional and when missing, the guides use an
algorithm similar to \code{IRanges::disjointBins()} to avoid overlaps.

The \code{key_range_auto()} does \emph{not} work with expression labels.
}
\examples{
# Example scale
template <- scale_x_discrete(limits = c("A 1", "B 1", "C&1", "D&2", "E&2"))

# By default, splits on all non-alphanumeric characters
auto <- key_range_auto()
auto(template)

# Only split on a specific character
auto <- key_range_auto(sep = "&")
auto(template)

# Treating the letters as outer labels and numbers as inner labels
auto <- key_range_auto(reverse = TRUE)
auto(template)

# Providing custom values
key_range_manual(
  start = c(1, 5,  10),
  end   = c(4, 15, 11),
  level = c(0, 2, 1),
  name  = c("A", "B", "C")
)

# Values from a <data.frame>
key_range_map(presidential, start = start, end = end, name = name)
}
\seealso{
Other keys: 
\code{\link{key_group}},
\code{\link{key_specialty}},
\code{\link{key_standard}}
}
\concept{keys}
