/*! esri-leaflet-renderers - v1.0.1 - 2015-11-30
*   Copyright (c) 2015 Environmental Systems Research Institute, Inc.
*   Apache 2.0 License */


var EsriLeafletRenderers={VERSION:"1.0.1"};if("undefined"!=typeof window&&window.L&&window.L.esri&&(window.L.esri.Renderers=EsriLeafletRenderers),!Esri)var Esri=window.L.esri;EsriLeafletRenderers.Symbol=L.Class.extend({initialize:function(a,b){this._symbolJson=a,this.val=null,this._styles={},this._isDefault=!1,this._layerTransparency=1,b&&b.layerTransparency&&(this._layerTransparency=1-b.layerTransparency/100)},pixelValue:function(a){return 1.333*a},colorValue:function(a){return"rgb("+a[0]+","+a[1]+","+a[2]+")"},alphaValue:function(a){var b=a[3]/255;return b*this._layerTransparency},getSize:function(a,b){var c=a.properties,d=b.field,e=0,f=null;if(d){f=c[d];var g,h=b.minSize,i=b.maxSize,j=b.minDataValue,k=b.maxDataValue,l=b.normalizationField,m=c?parseFloat(c[l]):void 0;if(null===f||l&&(isNaN(m)||0===m))return null;isNaN(m)||(f/=m),null!==h&&null!==i&&null!==j&&null!==k&&(j>=f?e=h:f>=k?e=i:(g=(f-j)/(k-j),e=h+g*(i-h))),e=isNaN(e)?0:e}return e},getColor:function(a,b){if(!(a.properties&&b&&b.field&&b.stops))return null;var c,d,e,f,g=a.properties,h=g[b.field],i=b.normalizationField,j=g?parseFloat(g[i]):void 0;if(null===h||i&&(isNaN(j)||0===j))return null;if(isNaN(j)||(h/=j),h<=b.stops[0].value)return b.stops[0].color;var k=b.stops[b.stops.length-1];if(h>=k.value)return k.color;for(var l=0;l<b.stops.length;l++){var m=b.stops[l];if(m.value<=h)c=m.color,e=m.value;else if(m.value>h){d=m.color,f=m.value;break}}if(!isNaN(e)&&!isNaN(f)){var n=f-e;if(n>0){var o=(h-e)/n;if(o){var p=(f-h)/n;if(p){for(var q=[],r=0;4>r;r++)q[r]=Math.round(c[r]*p+d[r]*o);return q}return d}return c}}return null}}),EsriLeafletRenderers.PointSymbol=EsriLeafletRenderers.Symbol.extend({statics:{MARKERTYPES:["esriSMSCircle","esriSMSCross","esriSMSDiamond","esriSMSSquare","esriSMSX","esriPMS"]},initialize:function(a,b){if(EsriLeafletRenderers.Symbol.prototype.initialize.call(this,a,b),b&&(this.serviceUrl=b.url),a)if("esriPMS"===a.type){var c=this.serviceUrl+"images/"+this._symbolJson.url;this._iconUrl=b&&b.token?c+"?token="+b.token:c,this._icons={},this.icon=this._createIcon(this._symbolJson)}else this._fillStyles()},_fillStyles:function(){this._symbolJson.outline&&this._symbolJson.size>0?(this._styles.stroke=!0,this._styles.weight=this.pixelValue(this._symbolJson.outline.width),this._styles.color=this.colorValue(this._symbolJson.outline.color),this._styles.opacity=this.alphaValue(this._symbolJson.outline.color)):this._styles.stroke=!1,this._symbolJson.color?(this._styles.fillColor=this.colorValue(this._symbolJson.color),this._styles.fillOpacity=this.alphaValue(this._symbolJson.color)):this._styles.fillOpacity=0,"esriSMSCircle"===this._symbolJson.style&&(this._styles.radius=this.pixelValue(this._symbolJson.size)/2)},_createIcon:function(a){var b=this.pixelValue(a.width),c=b;a.height&&(c=this.pixelValue(a.height));var d=b/2,e=c/2;a.xoffset&&(d+=this.pixelValue(a.xoffset)),a.yoffset&&(e+=this.pixelValue(a.yoffset));var f=L.icon({iconUrl:this._iconUrl,iconSize:[b,c],iconAnchor:[d,e]});return this._icons[a.width.toString()]=f,f},_getIcon:function(a){var b=this._icons[a.toString()];return b||(b=this._createIcon({width:a})),b},pointToLayer:function(a,b,c){var d=this._symbolJson.size||this._symbolJson.width;if(!this._isDefault){if(c.sizeInfo){var e=this.getSize(a,c.sizeInfo);e&&(d=e)}if(c.colorInfo){var f=this.getColor(a,c.colorInfo);f&&(this._styles.fillColor=this.colorValue(f),this._styles.fillOpacity=this.alphaValue(f))}}if("esriPMS"===this._symbolJson.type)return L.marker(b,{icon:this._getIcon(d)});switch(d=this.pixelValue(d),this._symbolJson.style){case"esriSMSSquare":return EsriLeafletRenderers.squareMarker(b,d,this._styles);case"esriSMSDiamond":return EsriLeafletRenderers.diamondMarker(b,d,this._styles);case"esriSMSCross":return EsriLeafletRenderers.crossMarker(b,d,this._styles);case"esriSMSX":return EsriLeafletRenderers.xMarker(b,d,this._styles)}return this._styles.radius=d/2,L.circleMarker(b,this._styles)}}),EsriLeafletRenderers.pointSymbol=function(a,b){return new EsriLeafletRenderers.PointSymbol(a,b)},EsriLeafletRenderers.LineSymbol=EsriLeafletRenderers.Symbol.extend({statics:{LINETYPES:["esriSLSDash","esriSLSDot","esriSLSDashDotDot","esriSLSDashDot","esriSLSSolid"]},initialize:function(a,b){EsriLeafletRenderers.Symbol.prototype.initialize.call(this,a,b),this._fillStyles()},_fillStyles:function(){if(this._styles.lineCap="butt",this._styles.lineJoin="miter",this._styles.fill=!1,this._symbolJson&&(this._symbolJson.color&&(this._styles.color=this.colorValue(this._symbolJson.color),this._styles.opacity=this.alphaValue(this._symbolJson.color)),this._symbolJson.width)){this._styles.weight=this.pixelValue(this._symbolJson.width);var a=[];switch(this._symbolJson.style){case"esriSLSDash":a=[4,3];break;case"esriSLSDot":a=[1,3];break;case"esriSLSDashDot":a=[8,3,1,3];break;case"esriSLSDashDotDot":a=[8,3,1,3,1,3]}if(a.length>0){for(var b=0;b<a.length;b++)a[b]*=this._styles.weight;this._styles.dashArray=a.join(",")}}},style:function(a,b){if(!this._isDefault&&b){if(b.sizeInfo){var c=this.pixelValue(this.getSize(a,b.sizeInfo));c&&(this._styles.weight=c)}if(b.colorInfo){var d=this.getColor(a,b.colorInfo);d&&(this._styles.color=this.colorValue(d),this._styles.opacity=this.alphaValue(d))}}return this._styles}}),EsriLeafletRenderers.lineSymbol=function(a,b){return new EsriLeafletRenderers.LineSymbol(a,b)},EsriLeafletRenderers.PolygonSymbol=EsriLeafletRenderers.Symbol.extend({statics:{POLYGONTYPES:["esriSFSSolid"]},initialize:function(a,b){EsriLeafletRenderers.Symbol.prototype.initialize.call(this,a,b),a&&(this._lineStyles=EsriLeafletRenderers.lineSymbol(a.outline,b).style(),this._fillStyles())},_fillStyles:function(){if(this._lineStyles)if(0===this._lineStyles.weight)this._styles.stroke=!1;else for(var a in this._lineStyles)this._styles[a]=this._lineStyles[a];this._symbolJson&&(this._symbolJson.color&&EsriLeafletRenderers.PolygonSymbol.POLYGONTYPES.indexOf(this._symbolJson.style>=0)?(this._styles.fill=!0,this._styles.fillColor=this.colorValue(this._symbolJson.color),this._styles.fillOpacity=this.alphaValue(this._symbolJson.color)):(this._styles.fill=!1,this._styles.fillOpacity=0))},style:function(a,b){if(!this._isDefault&&b&&b.colorInfo){var c=this.getColor(a,b.colorInfo);c&&(this._styles.fillColor=this.colorValue(c),this._styles.fillOpacity=this.alphaValue(c))}return this._styles}}),EsriLeafletRenderers.polygonSymbol=function(a,b){return new EsriLeafletRenderers.PolygonSymbol(a,b)},EsriLeafletRenderers.Renderer=L.Class.extend({options:{proportionalPolygon:!1,clickable:!0},initialize:function(a,b){this._rendererJson=a,this._pointSymbols=!1,this._symbols=[],this._visualVariables=this._parseVisualVariables(a.visualVariables),L.Util.setOptions(this,b)},_parseVisualVariables:function(a){var b={};if(a)for(var c=0;c<a.length;c++)b[a[c].type]=a[c];return b},_createDefaultSymbol:function(){this._rendererJson.defaultSymbol&&(this._defaultSymbol=this._newSymbol(this._rendererJson.defaultSymbol),this._defaultSymbol._isDefault=!0)},_newSymbol:function(a){return"esriSMS"===a.type||"esriPMS"===a.type?(this._pointSymbols=!0,EsriLeafletRenderers.pointSymbol(a,this.options)):"esriSLS"===a.type?EsriLeafletRenderers.lineSymbol(a,this.options):"esriSFS"===a.type?EsriLeafletRenderers.polygonSymbol(a,this.options):void 0},_getSymbol:function(){},attachStylesToLayer:function(a){this._pointSymbols?a.options.pointToLayer=L.Util.bind(this.pointToLayer,this):a.options.style=L.Util.bind(this.style,this)},pointToLayer:function(a,b){var c=this._getSymbol(a);return c&&c.pointToLayer?c.pointToLayer(a,b,this._visualVariables):L.circleMarker(b,{radius:0,opacity:0})},style:function(a){var b=this._getSymbol(a);return b?b.style(a,this._visualVariables):{opacity:0,fillOpacity:0}}}),EsriLeafletRenderers.SimpleRenderer=EsriLeafletRenderers.Renderer.extend({initialize:function(a,b){EsriLeafletRenderers.Renderer.prototype.initialize.call(this,a,b),this._createSymbol()},_createSymbol:function(){this._rendererJson.symbol&&this._symbols.push(this._newSymbol(this._rendererJson.symbol))},_getSymbol:function(){return this._symbols[0]}}),EsriLeafletRenderers.simpleRenderer=function(a,b){return new EsriLeafletRenderers.SimpleRenderer(a,b)},EsriLeafletRenderers.ClassBreaksRenderer=EsriLeafletRenderers.Renderer.extend({initialize:function(a,b){EsriLeafletRenderers.Renderer.prototype.initialize.call(this,a,b),this._field=this._rendererJson.field,this._rendererJson.normalizationType&&"esriNormalizeByField"===this._rendererJson.normalizationType&&(this._normalizationField=this._rendererJson.normalizationField),this._createSymbols()},_createSymbols:function(){var a,b=this._rendererJson.classBreakInfos;this._symbols=[];for(var c=b.length-1;c>=0;c--)a=this.options.proportionalPolygon&&this._rendererJson.backgroundFillSymbol?this._newSymbol(this._rendererJson.backgroundFillSymbol):this._newSymbol(b[c].symbol),a.val=b[c].classMaxValue,this._symbols.push(a);this._symbols.sort(function(a,b){return a.val>b.val?1:-1}),this._createDefaultSymbol(),this._maxValue=this._symbols[this._symbols.length-1].val},_getSymbol:function(a){var b=a.properties[this._field];if(this._normalizationField){var c=a.properties[this._normalizationField];if(isNaN(c)||0===c)return this._defaultSymbol;b/=c}if(b>this._maxValue)return this._defaultSymbol;for(var d=this._symbols[0],e=this._symbols.length-1;e>=0&&!(b>this._symbols[e].val);e--)d=this._symbols[e];return d}}),EsriLeafletRenderers.classBreaksRenderer=function(a,b){return new EsriLeafletRenderers.ClassBreaksRenderer(a,b)},EsriLeafletRenderers.UniqueValueRenderer=EsriLeafletRenderers.Renderer.extend({initialize:function(a,b){EsriLeafletRenderers.Renderer.prototype.initialize.call(this,a,b),this._field=this._rendererJson.field1,this._createSymbols()},_createSymbols:function(){for(var a,b=this._rendererJson.uniqueValueInfos,c=b.length-1;c>=0;c--)a=this._newSymbol(b[c].symbol),a.val=b[c].value,this._symbols.push(a);this._createDefaultSymbol()},_getSymbol:function(a){var b=a.properties[this._field];if(this._rendererJson.fieldDelimiter&&this._rendererJson.field2){var c=a.properties[this._rendererJson.field2];if(c){b+=this._rendererJson.fieldDelimiter+c;var d=a.properties[this._rendererJson.field3];d&&(b+=this._rendererJson.fieldDelimiter+d)}}for(var e=this._defaultSymbol,f=this._symbols.length-1;f>=0;f--)this._symbols[f].val==b&&(e=this._symbols[f]);return e}}),EsriLeafletRenderers.uniqueValueRenderer=function(a,b){return new EsriLeafletRenderers.UniqueValueRenderer(a,b)},EsriLeafletRenderers.SquareMarker=L.Path.extend({options:{fill:!0},initialize:function(a,b,c){L.Path.prototype.initialize.call(this,c),this._size=b,this._center=a},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._center)},getPathString:function(){if(!this._map)return"";var a=this._point,b=this._size/2;L.Path.VML&&(a._round(),b=Math.round(b));var c="M"+(a.x+b)+","+(a.y+b)+"L"+(a.x-b)+","+(a.y+b)+"L"+(a.x-b)+","+(a.y-b)+"L"+(a.x+b)+","+(a.y-b);return c+(L.Browser.svg?"z":"x")},setLatLng:function(a){return this._center=a,this.redraw()},getLatLng:function(){return L.latLng(this._center)},getSize:function(){return this._size},setSize:function(a){return this._size=a,this.redraw()}}),EsriLeafletRenderers.squareMarker=function(a,b,c){return new EsriLeafletRenderers.SquareMarker(a,b,c)},EsriLeafletRenderers.DiamondMarker=L.Path.extend({options:{fill:!0},initialize:function(a,b,c){L.Path.prototype.initialize.call(this,c),this._size=b,this._center=a},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._center)},getPathString:function(){if(!this._map)return"";var a=this._point,b=this._size/2;L.Path.VML&&(a._round(),b=Math.round(b));var c="M"+a.x+","+(a.y+b)+"L"+(a.x-b)+","+a.y+"L"+a.x+","+(a.y-b)+"L"+(a.x+b)+","+a.y;return c+(L.Browser.svg?"z":"x")},setLatLng:function(a){return this._center=a,this.redraw()},getLatLng:function(){return L.latLng(this._center)},getSize:function(){return this._size},setSize:function(a){return this._size=a,this.redraw()}}),EsriLeafletRenderers.diamondMarker=function(a,b,c){return new EsriLeafletRenderers.DiamondMarker(a,b,c)},EsriLeafletRenderers.CrossMarker=L.Path.extend({initialize:function(a,b,c){L.Path.prototype.initialize.call(this,c),this._size=b,this._center=a},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._center)},getPathString:function(){if(!this._map)return"";var a=this._point,b=this._size/2;return L.Path.VML&&(a._round(),b=Math.round(b)),"M"+a.x+","+(a.y+b)+"L"+a.x+","+(a.y-b)+"M"+(a.x-b)+","+a.y+"L"+(a.x+b)+","+a.y},setLatLng:function(a){return this._center=a,this.redraw()},getLatLng:function(){return L.latLng(this._center)},getSize:function(){return this._size},setSize:function(a){return this._size=a,this.redraw()}}),EsriLeafletRenderers.crossMarker=function(a,b,c){return new EsriLeafletRenderers.CrossMarker(a,b,c)},EsriLeafletRenderers.XMarker=L.Path.extend({initialize:function(a,b,c){L.Path.prototype.initialize.call(this,c),this._size=b,this._center=a},projectLatlngs:function(){this._point=this._map.latLngToLayerPoint(this._center)},getPathString:function(){if(!this._map)return"";var a=this._point,b=this._size/2;return L.Path.VML&&(a._round(),b=Math.round(b)),"M"+(a.x+b)+","+(a.y+b)+"L"+(a.x-b)+","+(a.y-b)+"M"+(a.x-b)+","+(a.y+b)+"L"+(a.x+b)+","+(a.y-b)},setLatLng:function(a){return this._center=a,this.redraw()},getLatLng:function(){return L.latLng(this._center)},getSize:function(){return this._size},setSize:function(a){return this._size=a,this.redraw()}}),EsriLeafletRenderers.xMarker=function(a,b,c){return new EsriLeafletRenderers.XMarker(a,b,c)};var initializeRenderers=function(){var a=L.Util.bind(this.onAdd,this),b=L.Util.bind(this.unbindPopup,this),c=L.Util.bind(this.onRemove,this);L.Util.bind(this.createNewLayer,this),this.metadata(function(b,c){b||(c&&c.drawingInfo&&!this.options.style&&this._setRenderers(c),this._metadataLoaded=!0,this._loadedMap&&(a(this._loadedMap),this._addPointLayer(this._loadedMap)))},this),this.onAdd=function(b){this._loadedMap=b,this._metadataLoaded&&(a(this._loadedMap),this._addPointLayer(this._loadedMap))},this.onRemove=function(a){if(c(a),this._pointLayer){var b=this._pointLayer.getLayers();for(var d in b)a.removeLayer(b[d])}},this.unbindPopup=function(){if(b(),this._pointLayer){var a=this._pointLayer.getLayers();for(var c in a)a[c].unbindPopup()}},this._addPointLayer=function(a){this._pointLayer&&(this._pointLayer.addTo(a),this._pointLayer.bringToFront())},this._createPointLayer=function(){if(!this._pointLayer&&(this._pointLayer=L.geoJson(),this._pointLayerIds={},this._popup)){var a=function(a,b){b.bindPopup(this._popup(a,b),this._popupOptions)};this._pointLayer.options.onEachFeature=L.Util.bind(a,this)}},this.createNewLayer=function(a){var b=L.GeoJSON.geometryToLayer(a,this.options.pointToLayer,L.GeoJSON.coordsToLatLng,this.options);if(this._hasProportionalSymbols){var c=this.getPolygonCentroid(a.geometry.coordinates);if(!isNaN(c[0])&&!isNaN(c[0])){this._createPointLayer();var d=a.id.toString();if(!this._pointLayerIds[d]){var e=this.getPointJson(a,c);this._pointLayer.addData(e),this._pointLayerIds[d]=!0}this._pointLayer.bringToFront()}}return b},this.getPolygonCentroid=function(a){var b=a[0][0];2===b.length&&(b=a[0]);for(var c,d,e,f=0,g=0,h=0,i=b.length,j=0,k=i-1;i>j;k=j++)c=b[j],d=b[k],f+=c[0]*d[1],f-=c[1]*d[0],e=c[0]*d[1]-d[0]*c[1],g+=(c[0]+d[0])*e,h+=(c[1]+d[1])*e;return e=3*f,[g/e,h/e]},this.getPointJson=function(a,b){return{type:"Feature",properties:a.properties,id:a.id,geometry:{type:"Point",coordinates:[b[0],b[1]]}}},this._checkForProportionalSymbols=function(a,b){if(this._hasProportionalSymbols=!1,"esriGeometryPolygon"===a&&(b.backgroundFillSymbol&&(this._hasProportionalSymbols=!0),b.classBreakInfos&&b.classBreakInfos.length)){var c=b.classBreakInfos[0].symbol;!c||"esriSMS"!==c.type&&"esriPMS"!==c.type||(this._hasProportionalSymbols=!0)}},this._setRenderers=function(a){var b,c=a.drawingInfo.renderer,d={url:this.url?this.url:this._service.options.url,token:this._service.options.token};switch(a.drawingInfo.transparency&&(d.layerTransparency=a.drawingInfo.transparency),c.type){case"classBreaks":if(this._checkForProportionalSymbols(a.geometryType,c),this._hasProportionalSymbols){this._createPointLayer();var e=EsriLeafletRenderers.classBreaksRenderer(c,d);e.attachStylesToLayer(this._pointLayer),d.proportionalPolygon=!0}b=EsriLeafletRenderers.classBreaksRenderer(c,d);break;case"uniqueValue":b=EsriLeafletRenderers.uniqueValueRenderer(c,d);break;default:b=EsriLeafletRenderers.simpleRenderer(c,d)}b.attachStylesToLayer(this)}};Esri.FeatureLayer.addInitHook(initializeRenderers),Esri.ClusteredFeatureLayer&&Esri.ClusteredFeatureLayer.addInitHook(initializeRenderers);
//# sourceMappingURL=esri-leaflet-renderers.js.map