% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetSearchItems}
\alias{GetSearchItems}
\title{Options for 'Search Items'}
\usage{
GetSearchItems(
  model = TRUE,
  type1 = FALSE,
  type2 = FALSE,
  bestK = 1L,
  all = FALSE,
  inclusion = FALSE,
  cdfs = NULL,
  extremeMultiplier = 0,
  mixture4 = FALSE
)
}
\arguments{
\item{model}{(bool) If true, information about the models is saved.}

\item{type1}{(bool) If true and implemented, extra information is saved. This can be the coefficients in the SUR search or predictions in VARMA search.}

\item{type2}{(bool) If true and implemented, extra information is saved. This is similar to \code{type1}. \strong{It is reserved for future updates.}}

\item{bestK}{(int) Number of best items to be saved in \code{model}, \code{type1}, or \code{type2} information.}

\item{all}{(bool) If true, all available information is saved.}

\item{inclusion}{(bool) If true, inclusion weights are saved in \code{model}.}

\item{cdfs}{(nullable numeric vector) Weighted average of the CDFs at each given point is calculated (for \code{type1} and \code{type2}).}

\item{extremeMultiplier}{(double) Determined the multiplier in the extreme bound analysis (for \code{type1} and \code{type2}).}

\item{mixture4}{(bool) If true, the first 4 moments of the average distributions are calculated in \code{type1} and \code{type2}.}
}
\value{
A list with the given options.
}
\description{
Creates a list with predefined items which determines the information to be saved and retrieved.
}
