% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_prob_array}
\alias{get_prob_array}
\title{Obtain the distribution of genotypes given haplotype frequencies under HWE}
\usage{
get_prob_array(K, prob, log_p = TRUE)
}
\arguments{
\item{K}{The ploidy of the species.}

\item{prob}{Haplotype frequencies in the order of (ab, Ab, aB, AB).}

\item{log_p}{A logical. Should we return the log-probabilities (\code{TRUE})
or the probabilities (\code{FALSE}). Defaults to \code{TRUE}.}
}
\value{
Element (i, j) is the (log) probability of genotype i-1 at locus 1
and genotype j-1 at locus 2.
}
\description{
This function will calculate the (log) probabilities for all genotype
combinations at two loci given just the haplotype frequencies. This
is under the assumptions of HWE.
}
\examples{
get_prob_array(K = 6, prob = c(0.1, 0.2, 0.3, 0.4), log_p = FALSE)

}
\author{
David Gerard
}
