% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liouville.R
\name{Liouville}
\alias{Liouville}
\alias{dliouv}
\alias{pliouv}
\alias{rliouv}
\title{Liouville copulas}
\usage{
rliouv(n = 100, family, alphavec, theta, reverse = FALSE)

pliouv(x, theta, family, alphavec)

dliouv(x, family, alphavec, theta, is.log = FALSE)
}
\arguments{
\item{n}{sample size}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alphavec}{vector of Dirichlet allocations (must be a vector of integers) Specifies (implictly) the dimension of sample}

\item{theta}{parameter of the corresponding Archimedean copula}

\item{reverse}{if \code{TRUE}, return sample from the corresponding survival copula}

\item{x}{matrix of quantiles from a Liouville copula}

\item{is.log}{if \code{TRUE}, will return the log-likelihood value}
}
\value{
either a matrix of dimension \code{n} by \code{length(alphavec)}  with the corresponding quantile, probability, survival probability or sample from the Liouville vector
}
\description{
Multivariate density, survival copula
and random generation for the Liouville copulas.

\bold{Liouville copula function}
}
\details{
\code{rliouv} generates draws from the Liouville copula. \code{dliouv} evaluates the density of an \code{n} by \code{d} matrix of observations. \code{pliouv} is the (survival) copula associated with the Liouville vector and is as such the multivariate distribution function for uniform observations.

Liouville copulas were introduced in McNeil and Neslehova (2010), generalizing Archimedean copulas. Like the latter, they
are survival copulas, which means that the copula is evaluated using the (multivariate) survival function of Liouville vectors. See also \code{\link{sliouv}} for the latter.

The Liouville copula is by definition a survival copula. The function thus
maps marginally observations from the unit interval to the positive half-line using the marginal inverse
survival function \code{\link{isliouvm}} of the Liouville vector, and then evaluating the survival
distribution at the resulting Liouville vector.
}
\examples{
#Multivariate density of Clayton Liouville copula
x <- rliouv(n = 100, family = "clayton", alphavec <- c(2,3), theta = 2)
dliouv(x=x, family="clayton", alphavec=c(2,3), theta=2, TRUE)
#Distribution function, multivariate sample
x <- rliouv(n=100, family="frank", theta=1.5, alphavec=c(2,3))
pliouv(theta=1.5, x=x,family="frank", alphavec=c(2,3))
}
\references{
McNeil A.J. and Neslehova, J.G. (2010) From Archimedean to Liouville Copulas. \emph{J. Multivar. Anal.}, \strong{101}(8): 1772--1790.
}
\seealso{
\code{\link{Liouville_marginal}}
}

