% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{fitted.lcc}
\alias{fitted.lcc}
\title{Extract \code{lcc} Fitted Values}
\usage{
\method{fitted}{lcc}(object, type, digits, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{lcc},
representing a fitted longitudinal concordance correlation
function.}

\item{type}{an optional character string specifying the type of
output to be returned. If \code{type="lcc"}, prints the fitted
longitudinal concordance correlation. If
\code{type="lpc"}, prints the fitted longitudinal Pearson
correlation. If \code{type="la"}, prints the fitted longitudinal
accuracy. Defaults to \code{type="lcc"}.}

\item{digits}{a non-null value for \code{digits} specifies the minimum
number of significant digits to be printed in values. The
default, \code{NULL}.}

\item{...}{not used.}
}
\value{
A data frame with columns given by methods, time, and
  fitted values.
}
\description{
Fitted values from object of class \code{lcc}
  returned by modeling functions.
}
\examples{
data(hue)
## Second degree polynomial model with random intercept, slope and
## quadratic term
\dontrun{
fm1 <- lcc(data = hue, subject = "Fruit", resp = "H_mean",
           method = "Method", time = "Time", qf = 2, qr = 2,
           components = TRUE)
fitted(fm1)
fitted(fm1, type="lpc")
fitted(fm1, type="la")
}

}
\seealso{
\code{\link[lcc]{lcc}}, \code{\link[lcc]{summary.lcc}},
  \code{\link[lcc]{lccPlot}}
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@usp.br}
}
