% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{setLink}
\alias{setLink}
\alias{setLink.lvm}
\title{Set a Link to a Value}
\usage{
setLink(x, ...)

\method{setLink}{lvm}(x, var1, var2, value, warnings = FALSE, ...)
}
\arguments{
\item{x}{a lvm model}

\item{...}{additional arguments to be passed to lower levels functions.}

\item{var1}{the first variable (character) or a formula describing the link}

\item{var2}{the second variable (character). Only used if var1 is a character.}

\item{value}{the value to which the link should be set}

\item{warnings}{should a warning be displayed when the link is not found in the lvm.}
}
\description{
Generic interface to set a value to a link in a lvm object.
}
\examples{
library(lava)
set.seed(10)

m <- lvm()
regression(m) <- c(y1,y2,y3)~u
regression(m) <- u~x1+x2
latent(m) <- ~u
covariance(m) <- y1 ~ y2

m1 <- setLink(m, y3 ~ u, value = 1)
estimate(m1, lava::sim(m,1e2))
# m1 <- setLink(m, u ~ y3, value = 1)

m2 <- setLink(m, y1 ~ y2, value = 0.5)
estimate(m2, lava::sim(m,1e2))
}
