% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_val_labs.R
\name{get_val_labs}
\alias{get_val_labs}
\alias{gvl}
\title{Return Lookup Table of Variable Values and Value Labels}
\usage{
get_val_labs(data, var = NULL)

gvl(data, var = NULL)
}
\arguments{
\item{data}{a data.frame.}

\item{var}{a character vector with the name(s) of any specific variable(s)
(If NULL, returned data.frame will contain all variable value labels).}
}
\value{
A three-column data.frame, consisting of "var", "vals", and "labs"
columns, where each row corresponds to a unique value of a value-labeled
variable (column) from the user-supplied data.frame OR -- for variables
labeled using \code{add_quant_labs} (or \code{add_quant1}) -- the upper bound of
numerical values that fall within that label's range of coverage. Note that
all variables of the returned data.frame are coerced to character (see Note 1
of details).
}
\description{
For a data.frame with value-labeled variables, \code{get_val_labs} returns a
derivative data.frame that shows the value-to-label mapping for each unique
value of each value-labeled variable.
}
\details{
Note 1: Columns of the returned data.frame are coerced to character for
display purposes, as a result of concatenating value information from
different variables of potentially different classes. In particular, all
elements of the "vals" column are expressed as character even if the
underlying values themselves are numeric. Accordingly, the data.frame returned
by \code{get_val_labs} is intended to facilitate --visual-- display and inspection
of what (if any) value label has been associated with each variable value; it
is --not-- intended to be used for accurate determination of the underlying
classes or types of the variables as they exist in the primary data.frame that
you passed to it.

Note 2: \code{gvl} is a compact alias for \code{get_val_labs}: they do the same thing,
and the former is easier to type
}
\examples{
# add val labs to multiple variables at once
# make a "Likert"-type fake data set to demo
# note, by default, add_val_labs() "vars" arg will do partial matching
# in this case, we catch all vars with "x" in their name
set.seed(272)
dflik <- make_likert_data(scale = 1:7)
vals2label <- 1:7
labs2use <- c(
  "VSD",
  "SD",
  "D",
  "N",
  "A",
  "SA",
  "VSA"
)

dflik <- add_val_labs(
  data = dflik, vars = c("x", "y3"), # note the vars args
  vals = vals2label,
  labs = labs2use,
  partial = TRUE
)

# note, all "x" vars get the labs, as does "y3"
get_val_labs(dflik)
get_val_labs(dflik, "x1")
}
