% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_all_factors.R
\name{get_all_factors}
\alias{get_all_factors}
\title{Put Data Frame Factor Level Information into a List}
\usage{
get_all_factors(data)
}
\arguments{
\item{data}{the data.frame you are checking for factor variables.}
}
\value{
A list of 0, 1, or more character variables.
}
\description{
\code{get_all_factors} returns a list of character vectors, where each character
vector is a given factor variable's unique levels, and where the vector
is given the same name as the factor variable itself. If the data.frame
contains no factors, any empty (length 0) list is returned.
}
\examples{
class(get_all_factors(iris))
length(get_all_factors(iris))
zz <- iris
zz$u <- zz$Species # zz has two factor variables
class(get_all_factors(zz))
length(get_all_factors(zz))
get_all_factors(mtcars)
length(get_all_factors(mtcars))
}
