% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_values.R
\name{na_values}
\alias{na_values}
\alias{na_values<-}
\alias{na_range}
\alias{na_range<-}
\alias{get_na_values}
\alias{get_na_range}
\alias{set_na_values}
\alias{set_na_range}
\alias{is_user_na}
\alias{is_regular_na}
\alias{user_na_to_na}
\alias{user_na_to_regular_na}
\alias{user_na_to_tagged_na}
\title{Get / Set SPSS missing values}
\usage{
na_values(x)

na_values(x) <- value

na_range(x)

na_range(x) <- value

get_na_values(x)

get_na_range(x)

set_na_values(.data, ..., .values = NA, .strict = TRUE)

set_na_range(.data, ..., .values = NA, .strict = TRUE)

is_user_na(x)

is_regular_na(x)

user_na_to_na(x)

user_na_to_regular_na(x)

user_na_to_tagged_na(x)
}
\arguments{
\item{x}{A vector (or a data frame).}

\item{value}{A vector of values that should also be considered as missing
(for \code{na_values}) or a numeric vector of length two giving the (inclusive)
extents of the range (for \code{na_values}, use \code{-Inf} and \code{Inf} if you
want the range to be open ended).}

\item{.data}{a data frame or a vector}

\item{...}{name-value pairs of missing values (see examples)}

\item{.values}{missing values to be applied to the data.frame,
using the same syntax as \code{value} in \code{na_values(df) <- value} or
\code{na_range(df) <- value}.}

\item{.strict}{should an error be returned if some labels
doesn't correspond to a column of \code{x}?}
}
\value{
\code{na_values()} will return a vector of values that should also be
considered as missing.
\code{na_range()} will return a numeric vector of length two giving the
(inclusive) extents of the range.

\code{set_na_values()} and \code{set_na_range()} will return an updated
copy of \code{.data}.
}
\description{
Get / Set SPSS missing values
}
\details{
See \code{\link[haven:labelled_spss]{haven::labelled_spss()}} for a presentation of SPSS's user defined
missing values.

Note that \code{\link[base:NA]{base::is.na()}} will return \code{TRUE} for user defined missing values.
It will also return \code{TRUE} for regular \code{NA} values. If you want to test if a
specific value is a user NA but not a regular \code{NA}, use \code{is_user_na()}.
If you want to test if a value is a regular \code{NA} but not a user NA, not a
tagged NA, use \code{is_regular_na()}.

You can use \code{\link[=user_na_to_na]{user_na_to_na()}} to convert user defined missing values to
regular \code{NA}. Note that any value label attached to a user defined missing
value will be lost.
\code{\link[=user_na_to_regular_na]{user_na_to_regular_na()}} is a synonym of \code{\link[=user_na_to_na]{user_na_to_na()}}.

The method \code{\link[=user_na_to_tagged_na]{user_na_to_tagged_na()}} will convert user defined missing values
into \code{\link[haven:tagged_na]{haven::tagged_na()}}, preserving value labels. Please note that
\code{\link[haven:tagged_na]{haven::tagged_na()}} are defined only for double vectors. Therefore, integer
\code{haven_labelled_spss} vectors will be converted into double \code{haven_labelled}
vectors; and \code{\link[=user_na_to_tagged_na]{user_na_to_tagged_na()}} cannot be applied to a character
\code{haven_labelled_spss} vector.

\code{\link[=tagged_na_to_user_na]{tagged_na_to_user_na()}} is the opposite of \code{\link[=user_na_to_tagged_na]{user_na_to_tagged_na()}} and
convert tagged \code{NA} into user defined missing values.
}
\note{
\code{get_na_values()} is identical to \code{na_values()} and \code{get_na_range()}
to \code{na_range()}.

\code{set_na_values()} and \code{set_na_range()} could be used with \pkg{dplyr}
syntax.
}
\examples{
v <- labelled(
  c(1, 2, 2, 2, 3, 9, 1, 3, 2, NA),
  c(yes = 1, no = 3, "don't know" = 9)
)
v
na_values(v) <- 9
na_values(v)
v

is.na(v) # TRUE for the 6th and 10th values
is_user_na(v) # TRUE only for the 6th value

user_na_to_na(v)
na_values(v) <- NULL
v
na_range(v) <- c(5, Inf)
na_range(v)
v
user_na_to_na(v)
user_na_to_tagged_na(v)

# it is not recommended to mix user NAs and tagged NAs
x <- c(NA, 9, tagged_na("a"))
na_values(x) <- 9
x
is.na(x)
is_user_na(x)
is_tagged_na(x)
is_regular_na(x)

if (require(dplyr)) {
  # setting value label and user NAs
  df <- tibble(s1 = c("M", "M", "F", "F"), s2 = c(1, 1, 2, 9)) \%>\%
    set_value_labels(s2 = c(yes = 1, no = 2)) \%>\%
    set_na_values(s2 = 9)
  na_values(df)

  # removing missing values
  df <- df \%>\% set_na_values(s2 = NULL)
  df$s2

  # example with a vector
  v <- 1:10
  v <- v \%>\% set_na_values(5, 6, 7)
  v
  v \%>\% set_na_range(8, 10)
  v \%>\% set_na_range(.values = c(9, 10))
  v \%>\% set_na_values(NULL)
}
}
\seealso{
\code{\link[haven:labelled_spss]{haven::labelled_spss()}}, \code{\link[=user_na_to_na]{user_na_to_na()}}
}
