% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_false_positives}
\alias{metric_false_positives}
\title{Calculates the number of false positives}
\usage{
metric_false_positives(..., thresholds = NULL, name = NULL, dtype = NULL)
}
\arguments{
\item{...}{Passed on to the underlying metric. Used for forwards and backwards compatibility.}

\item{thresholds}{(Optional) Defaults to 0.5. A float value or a
list of float threshold values in \verb{[0, 1]}. A threshold is compared
with prediction values to determine the truth value of predictions
(i.e., above the threshold is \code{true}, below is \code{false}). One metric
value is generated for each threshold value.}

\item{name}{(Optional) string name of the metric instance.}

\item{dtype}{(Optional) data type of the metric result.}
}
\value{
A (subclassed) \code{Metric} instance that can be passed directly to
\code{compile(metrics = )}, or used as a standalone object. See \code{?Metric} for
example usage.
}
\description{
Calculates the number of false positives
}
\details{
If \code{sample_weight} is given, calculates the sum of the weights of
false positives. This metric creates one local variable, \code{accumulator}
that is used to keep track of the number of false positives.

If \code{sample_weight} is \code{NULL}, weights default to 1.
Use \code{sample_weight} of 0 to mask values.
}
\seealso{
Other metrics: 
\code{\link{custom_metric}()},
\code{\link{metric_accuracy}()},
\code{\link{metric_auc}()},
\code{\link{metric_binary_accuracy}()},
\code{\link{metric_binary_crossentropy}()},
\code{\link{metric_categorical_accuracy}()},
\code{\link{metric_categorical_crossentropy}()},
\code{\link{metric_categorical_hinge}()},
\code{\link{metric_cosine_similarity}()},
\code{\link{metric_false_negatives}()},
\code{\link{metric_hinge}()},
\code{\link{metric_kullback_leibler_divergence}()},
\code{\link{metric_logcosh_error}()},
\code{\link{metric_mean_absolute_error}()},
\code{\link{metric_mean_absolute_percentage_error}()},
\code{\link{metric_mean_iou}()},
\code{\link{metric_mean_relative_error}()},
\code{\link{metric_mean_squared_error}()},
\code{\link{metric_mean_squared_logarithmic_error}()},
\code{\link{metric_mean_tensor}()},
\code{\link{metric_mean_wrapper}()},
\code{\link{metric_mean}()},
\code{\link{metric_poisson}()},
\code{\link{metric_precision_at_recall}()},
\code{\link{metric_precision}()},
\code{\link{metric_recall_at_precision}()},
\code{\link{metric_recall}()},
\code{\link{metric_root_mean_squared_error}()},
\code{\link{metric_sensitivity_at_specificity}()},
\code{\link{metric_sparse_categorical_accuracy}()},
\code{\link{metric_sparse_categorical_crossentropy}()},
\code{\link{metric_sparse_top_k_categorical_accuracy}()},
\code{\link{metric_specificity_at_sensitivity}()},
\code{\link{metric_squared_hinge}()},
\code{\link{metric_sum}()},
\code{\link{metric_top_k_categorical_accuracy}()},
\code{\link{metric_true_negatives}()},
\code{\link{metric_true_positives}()}
}
\concept{metrics}
