% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{application_xception}
\alias{application_xception}
\alias{xception_preprocess_input}
\title{Xception V1 model for Keras.}
\usage{
application_xception(include_top = TRUE, weights = "imagenet",
  input_tensor = NULL, input_shape = NULL, pooling = NULL,
  classes = 1000)

xception_preprocess_input(x)
}
\arguments{
\item{include_top}{whether to include the fully-connected layer at the top of
the network.}

\item{weights}{\code{NULL} (random initialization), \code{imagenet} (ImageNet
weights), or the path to the weights file to be loaded.}

\item{input_tensor}{optional Keras tensor to use as image input for the
model.}

\item{input_shape}{optional shape list, only to be specified if \code{include_top}
is FALSE (otherwise the input shape has to be \code{(299, 299, 3)}. It should
have exactly 3 inputs channels, and width and height should be no smaller
than 71. E.g. \code{(150, 150, 3)} would be one valid value.}

\item{pooling}{Optional pooling mode for feature extraction when
\code{include_top} is \code{FALSE}.
\itemize{
\item \code{NULL} means that the output of the model will be the 4D tensor output
of the last convolutional layer.
\item \code{avg} means that global average pooling will be applied to the output of
the last convolutional layer, and thus the output of the model will be
a 2D tensor.
\item \code{max} means that global max pooling will be applied.
}}

\item{classes}{optional number of classes to classify images into, only to be
specified if \code{include_top} is TRUE, and if no \code{weights} argument is
specified.}

\item{x}{Input tensor for preprocessing}
}
\value{
A Keras model instance.
}
\description{
Xception V1 model for Keras.
}
\details{
On ImageNet, this model gets to a top-1 validation accuracy of 0.790
and a top-5 validation accuracy of 0.945.

Do note that the input image format for this model is different than for
the VGG16 and ResNet models (299x299 instead of 224x224).

The \code{xception_preprocess_input()} function should be used for image
preprocessing.

This application is only available when using the TensorFlow back-end.
}
\section{Reference}{

\itemize{
\item \href{https://arxiv.org/abs/1610.02357}{Xception: Deep Learning with Depthwise Separable Convolutions}
}
}

