% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augmentations.R
\name{jst_augment}
\alias{jst_augment}
\title{Clean data from DfR}
\usage{
jst_augment(meta_data, quietly = FALSE)
}
\arguments{
\item{meta_data}{Data which was processed via \code{\link[=jst_get_article]{jst_get_article()}}.}

\item{quietly}{Should warnings from converting page ranges be suppressed?}
}
\value{
A cleaned tibble.
}
\description{
This function takes data from \code{\link[=jst_get_article]{jst_get_article()}} and
applies helper functions for cleaning the data.
}
\details{
Data from DfR is inherently messy. For many examples see
\code{vignette("known-quirks", package = "jstor")}. \code{jst_augment()} is a
convenience function that tries to deal with a few common tasks to
clean the data.

For journal articles, it calls \code{\link[=jst_clean_page]{jst_clean_page()}} to convert first and last
page, \code{\link[=jst_unify_journal_id]{jst_unify_journal_id()}} and \code{\link[=jst_add_total_pages]{jst_add_total_pages()}}.
}
\seealso{
\code{\link[=jst_clean_page]{jst_clean_page()}} \code{\link[=jst_unify_journal_id]{jst_unify_journal_id()}} \code{\link[=jst_add_total_pages]{jst_add_total_pages()}}
\code{\link[=jst_get_total_pages]{jst_get_total_pages()}}
}
