% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.h.R
\name{descriptives}
\alias{descriptives}
\title{Descriptives}
\usage{
descriptives(
  data,
  vars,
  splitBy = NULL,
  freq = FALSE,
  hist = FALSE,
  dens = FALSE,
  bar = FALSE,
  barCounts = FALSE,
  box = FALSE,
  violin = FALSE,
  dot = FALSE,
  dotType = "jitter",
  qq = FALSE,
  n = TRUE,
  missing = TRUE,
  mean = TRUE,
  median = TRUE,
  mode = FALSE,
  sum = FALSE,
  sd = FALSE,
  variance = FALSE,
  range = FALSE,
  min = TRUE,
  max = TRUE,
  se = FALSE,
  skew = FALSE,
  kurt = FALSE,
  sw = FALSE,
  quart = FALSE,
  pcEqGr = FALSE,
  pcNEqGr = 4,
  formula
)
}
\arguments{
\item{data}{the data as a data frame}

\item{vars}{a vector of strings naming the variables of interest in
\code{data}}

\item{splitBy}{a vector of strings naming the variables used to split
\code{vars}}

\item{freq}{\code{TRUE} or \code{FALSE} (default), provide frequency tables
(nominal, ordinal variables only)}

\item{hist}{\code{TRUE} or \code{FALSE} (default), provide histograms
(continuous variables only)}

\item{dens}{\code{TRUE} or \code{FALSE} (default), provide density plots
(continuous variables only)}

\item{bar}{\code{TRUE} or \code{FALSE} (default), provide bar plots
(nominal, ordinal variables only)}

\item{barCounts}{\code{TRUE} or \code{FALSE} (default), add counts to the
bar plots}

\item{box}{\code{TRUE} or \code{FALSE} (default), provide box plots
(continuous variables only)}

\item{violin}{\code{TRUE} or \code{FALSE} (default), provide violin plots
(continuous variables only)}

\item{dot}{\code{TRUE} or \code{FALSE} (default), provide dot plots
(continuous variables only)}

\item{dotType}{.}

\item{qq}{\code{TRUE} or \code{FALSE} (default), provide Q-Q plots
(continuous variables only)}

\item{n}{\code{TRUE} (default) or \code{FALSE}, provide the sample size}

\item{missing}{\code{TRUE} (default) or \code{FALSE}, provide the number of
missing values}

\item{mean}{\code{TRUE} (default) or \code{FALSE}, provide the mean}

\item{median}{\code{TRUE} (default) or \code{FALSE}, provide the median}

\item{mode}{\code{TRUE} or \code{FALSE} (default), provide the mode}

\item{sum}{\code{TRUE} or \code{FALSE} (default), provide the sum}

\item{sd}{\code{TRUE} or \code{FALSE} (default), provide the standard
deviation}

\item{variance}{\code{TRUE} or \code{FALSE} (default), provide the variance}

\item{range}{\code{TRUE} or \code{FALSE} (default), provide the range}

\item{min}{\code{TRUE} or \code{FALSE} (default), provide the minimum}

\item{max}{\code{TRUE} or \code{FALSE} (default), provide the maximum}

\item{se}{\code{TRUE} or \code{FALSE} (default), provide the standard error}

\item{skew}{\code{TRUE} or \code{FALSE} (default), provide the skewness}

\item{kurt}{\code{TRUE} or \code{FALSE} (default), provide the kurtosis}

\item{sw}{\code{TRUE} or \code{FALSE} (default), provide Shapiro-Wilk
p-value}

\item{quart}{\code{TRUE} or \code{FALSE} (default), provide quartiles}

\item{pcEqGr}{\code{TRUE} or \code{FALSE} (default), provide quantiles}

\item{pcNEqGr}{an integer (default: 4) specifying the number of equal
groups}

\item{formula}{(optional) the formula to use, see the examples}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$descriptives} \tab \tab \tab \tab \tab a table of the descriptive statistics \cr
  \code{results$frequencies} \tab \tab \tab \tab \tab an array of frequency tables \cr
  \code{results$plots} \tab \tab \tab \tab \tab an array of descriptive plots \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$descriptives$asDF}

\code{as.data.frame(results$descriptives)}
}
\description{
Descriptives are an assortment of summarising statistics, and 
visualizations which allow exploring the shape and distribution of data. It 
is good practice to explore your data with descriptives before proceeding 
to more formal tests.
}
\examples{
\dontrun{
data('mtcars')
dat <- mtcars

# frequency tables can be provided for factors
dat$gear <- as.factor(dat$gear)

descriptives(dat, vars = vars(mpg, cyl, disp, gear), freq = TRUE)

#
#  DESCRIPTIVES
#
#  Descriptives
#  -------------------------------------------
#               mpg     cyl     disp    gear
#  -------------------------------------------
#    N            32      32      32      32
#    Missing       0       0       0       0
#    Mean       20.1    6.19     231    3.69
#    Median     19.2    6.00     196    4.00
#    Minimum    10.4    4.00    71.1       3
#    Maximum    33.9    8.00     472       5
#  -------------------------------------------
#
#
#  FREQUENCIES
#
#  Frequencies of gear
#  --------------------
#    Levels    Counts
#  --------------------
#    3             15
#    4             12
#    5              5
#  --------------------
#

# spliting by a variable
descriptives(formula = disp + mpg ~ cyl, dat,
    median=F, min=F, max=F, n=F, missing=F)

# providing histograms
descriptives(formula = mpg ~ cyl, dat, hist=T,
    median=F, min=F, max=F, n=F, missing=F)

# splitting by multiple variables
descriptives(formula = mpg ~ cyl:gear, dat,
    median=F, min=F, max=F, missing=F)
}
}
