% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttestis.h.R
\name{ttestIS}
\alias{ttestIS}
\title{Independent Samples T-Test}
\usage{
ttestIS(data, vars, group, students = TRUE, bf = FALSE, bfPrior = 0.707,
  welchs = FALSE, mann = FALSE, hypothesis = "different", norm = FALSE,
  qq = FALSE, eqv = FALSE, meanDiff = FALSE, effectSize = FALSE,
  ci = FALSE, ciWidth = 95, desc = FALSE, plots = FALSE,
  miss = "perAnalysis")
}
\arguments{
\item{data}{the data as a data frame}

\item{vars}{a vector of strings naming the dependent variables}

\item{group}{a string naming the grouping variable, must have 2 levels}

\item{students}{\code{TRUE} (default) or \code{FALSE}, perform Student's
t-tests}

\item{bf}{\code{TRUE} or \code{FALSE} (default), provide Bayes factors}

\item{bfPrior}{a number between 0.5 and 2 (default 0.707), the prior width
to use in calculating Bayes factors}

\item{welchs}{\code{TRUE} or \code{FALSE} (default), perform Welch's
t-tests}

\item{mann}{\code{TRUE} or \code{FALSE} (default), perform Mann-Whitney U
tests}

\item{hypothesis}{\code{'different'} (default), \code{'oneGreater'} or
\code{'twoGreater'}, the alternative hypothesis; group 1 different to group
2, group 1 greater than group 2, and group 2 greater than group 1
respectively}

\item{norm}{\code{TRUE} or \code{FALSE} (default), perform Shapiro-Wilk
test of normality}

\item{qq}{\code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of
residuals}

\item{eqv}{\code{TRUE} or \code{FALSE} (default), perform Levene's test for
equality of variances}

\item{meanDiff}{\code{TRUE} or \code{FALSE} (default), provide means and
standard errors}

\item{effectSize}{\code{TRUE} or \code{FALSE} (default), provide effect
sizes}

\item{ci}{\code{TRUE} or \code{FALSE} (default), provide confidence
intervals}

\item{ciWidth}{a number between 50 and 99.9 (default: 95), the width of
confidence intervals}

\item{desc}{\code{TRUE} or \code{FALSE} (default), provide descriptive
statistics}

\item{plots}{\code{TRUE} or \code{FALSE} (default), provide descriptive
plots}

\item{miss}{\code{'perAnalysis'} or \code{'listwise'}, how to handle
missing values; \code{'perAnalysis'} excludes missing values for individual
dependent variables, \code{'listwise'} excludes a row from all analyses if
one of its entries is missing.}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$ttest} \tab \tab \tab \tab \tab a table containing the t-test results \cr
  \code{results$assum$norm} \tab \tab \tab \tab \tab a table containing the normality tests \cr
  \code{results$assum$eqv} \tab \tab \tab \tab \tab a table containing the equality of variances tests \cr
  \code{results$desc} \tab \tab \tab \tab \tab a table containing the group descriptives \cr
  \code{results$plots} \tab \tab \tab \tab \tab an array of groups of plots \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$ttest$asDF}

\code{as.data.frame(results$ttest)}
}
\description{
Independent Samples T-Test
}
\examples{
data('ToothGrowth')

ttestIS(data = ToothGrowth, vars = 'len', group = 'supp')

#
#  INDEPENDENT SAMPLES T-TEST
#
#  Independent Samples T-Test
#  ----------------------------------------------------
#                          statistic    df      p
#  ----------------------------------------------------
#    len    Student's t         1.92    58.0    0.060
#  ----------------------------------------------------
#

}
