
# This file is automatically generated, you probably don't want to edit this

anovaOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "anovaOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            dep = NULL,
            factors = NULL,
            modelTerms = NULL,
            ss = "3",
            effectSize = NULL,
            contrasts = NULL,
            postHoc = NULL,
            postHocCorr = list(
                "tukey"),
            homo = FALSE,
            qq = FALSE,
            emMeans = list(
                list()),
            ciWidthEmm = 95,
            emmPlots = TRUE,
            emmPlotData = FALSE,
            emmPlotError = "ci",
            emmTables = FALSE,
            emmWeights = TRUE, ...) {

            super$initialize(
                package='jmv',
                name='anova',
                requiresData=TRUE,
                ...)

            private$..dep <- jmvcore::OptionVariable$new(
                "dep",
                dep,
                required=TRUE,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "numeric"))
            private$..factors <- jmvcore::OptionVariables$new(
                "factors",
                factors,
                required=TRUE,
                rejectUnusedLevels=TRUE,
                suggested=list(
                    "nominal",
                    "ordinal"),
                permitted=list(
                    "factor"),
                default=NULL)
            private$..modelTerms <- jmvcore::OptionTerms$new(
                "modelTerms",
                modelTerms,
                default=NULL)
            private$..ss <- jmvcore::OptionList$new(
                "ss",
                ss,
                options=list(
                    "1",
                    "2",
                    "3"),
                default="3")
            private$..effectSize <- jmvcore::OptionNMXList$new(
                "effectSize",
                effectSize,
                options=list(
                    "eta",
                    "partEta",
                    "omega"),
                default=NULL)
            private$..contrasts <- jmvcore::OptionArray$new(
                "contrasts",
                contrasts,
                items="(factors)",
                default=NULL,
                template=jmvcore::OptionGroup$new(
                    "contrasts",
                    NULL,
                    elements=list(
                        jmvcore::OptionVariable$new(
                            "var",
                            NULL,
                            content="$key"),
                        jmvcore::OptionList$new(
                            "type",
                            NULL,
                            options=list(
                                "none",
                                "deviation",
                                "simple",
                                "difference",
                                "helmert",
                                "repeated",
                                "polynomial")))))
            private$..postHoc <- jmvcore::OptionTerms$new(
                "postHoc",
                postHoc,
                default=NULL)
            private$..postHocCorr <- jmvcore::OptionNMXList$new(
                "postHocCorr",
                postHocCorr,
                options=list(
                    "none",
                    "tukey",
                    "scheffe",
                    "bonf",
                    "holm"),
                default=list(
                    "tukey"))
            private$..homo <- jmvcore::OptionBool$new(
                "homo",
                homo,
                default=FALSE)
            private$..qq <- jmvcore::OptionBool$new(
                "qq",
                qq,
                default=FALSE)
            private$..emMeans <- jmvcore::OptionArray$new(
                "emMeans",
                emMeans,
                default=list(
                    list()),
                template=jmvcore::OptionVariables$new(
                    "emMeans",
                    NULL))
            private$..ciWidthEmm <- jmvcore::OptionNumber$new(
                "ciWidthEmm",
                ciWidthEmm,
                min=50,
                max=99.9,
                default=95)
            private$..emmPlots <- jmvcore::OptionBool$new(
                "emmPlots",
                emmPlots,
                default=TRUE)
            private$..emmPlotData <- jmvcore::OptionBool$new(
                "emmPlotData",
                emmPlotData,
                default=FALSE)
            private$..emmPlotError <- jmvcore::OptionList$new(
                "emmPlotError",
                emmPlotError,
                options=list(
                    "none",
                    "ci",
                    "se"),
                default="ci")
            private$..emmTables <- jmvcore::OptionBool$new(
                "emmTables",
                emmTables,
                default=FALSE)
            private$..emmWeights <- jmvcore::OptionBool$new(
                "emmWeights",
                emmWeights,
                default=TRUE)

            self$.addOption(private$..dep)
            self$.addOption(private$..factors)
            self$.addOption(private$..modelTerms)
            self$.addOption(private$..ss)
            self$.addOption(private$..effectSize)
            self$.addOption(private$..contrasts)
            self$.addOption(private$..postHoc)
            self$.addOption(private$..postHocCorr)
            self$.addOption(private$..homo)
            self$.addOption(private$..qq)
            self$.addOption(private$..emMeans)
            self$.addOption(private$..ciWidthEmm)
            self$.addOption(private$..emmPlots)
            self$.addOption(private$..emmPlotData)
            self$.addOption(private$..emmPlotError)
            self$.addOption(private$..emmTables)
            self$.addOption(private$..emmWeights)
        }),
    active = list(
        dep = function() private$..dep$value,
        factors = function() private$..factors$value,
        modelTerms = function() private$..modelTerms$value,
        ss = function() private$..ss$value,
        effectSize = function() private$..effectSize$value,
        contrasts = function() private$..contrasts$value,
        postHoc = function() private$..postHoc$value,
        postHocCorr = function() private$..postHocCorr$value,
        homo = function() private$..homo$value,
        qq = function() private$..qq$value,
        emMeans = function() private$..emMeans$value,
        ciWidthEmm = function() private$..ciWidthEmm$value,
        emmPlots = function() private$..emmPlots$value,
        emmPlotData = function() private$..emmPlotData$value,
        emmPlotError = function() private$..emmPlotError$value,
        emmTables = function() private$..emmTables$value,
        emmWeights = function() private$..emmWeights$value),
    private = list(
        ..dep = NA,
        ..factors = NA,
        ..modelTerms = NA,
        ..ss = NA,
        ..effectSize = NA,
        ..contrasts = NA,
        ..postHoc = NA,
        ..postHocCorr = NA,
        ..homo = NA,
        ..qq = NA,
        ..emMeans = NA,
        ..ciWidthEmm = NA,
        ..emmPlots = NA,
        ..emmPlotData = NA,
        ..emmPlotError = NA,
        ..emmTables = NA,
        ..emmWeights = NA)
)

anovaResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        main = function() private$.items[["main"]],
        model = function() private$..model,
        assump = function() private$.items[["assump"]],
        contrasts = function() private$.items[["contrasts"]],
        postHoc = function() private$.items[["postHoc"]],
        emm = function() private$.items[["emm"]]),
    private = list(
        ..model = NA),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="ANOVA")
            self$add(jmvcore::Table$new(
                options=options,
                name="main",
                title="ANOVA",
                columns=list()))
            private$..model <- NULL
            self$add(R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    homo = function() private$.items[["homo"]],
                    qq = function() private$.items[["qq"]]),
                private = list(),
                public=list(
                    initialize=function(options) {
                        super$initialize(
                            options=options,
                            name="assump",
                            title="Assumption Checks")
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="homo",
                            title="Test for Homogeneity of Variances (Levene's)",
                            columns=list()))
                        self$add(jmvcore::Image$new(
                            options=options,
                            name="qq",
                            title="Q-Q Plot"))}))$new(options=options))
            self$add(jmvcore::Array$new(
                options=options,
                name="contrasts",
                title="Contrasts",
                template=jmvcore::Table$new(
                    options=options,
                    title="Contrasts - $key",
                    columns=list())))
            self$add(jmvcore::Array$new(
                options=options,
                name="postHoc",
                title="Post Hoc Tests",
                template=jmvcore::Table$new(
                    options=options,
                    title="",
                    columns=list())))
            self$add(jmvcore::Array$new(
                options=options,
                name="emm",
                title="Estimated Marginal Means",
                clearWith=list(
                    "dep",
                    "blocks",
                    "emMeans"),
                template=R6::R6Class(
                    inherit = jmvcore::Group,
                    active = list(
                        emmPlot = function() private$.items[["emmPlot"]],
                        emmTable = function() private$.items[["emmTable"]]),
                    private = list(),
                    public=list(
                        initialize=function(options) {
                            super$initialize(
                                options=options,
                                name="undefined",
                                title="")
                            self$add(jmvcore::Image$new(
                                options=options,
                                name="emmPlot",
                                title="",
                                width=450,
                                height=400,
                                renderFun=".emmPlot",
                                visible="(emmPlots)",
                                clearWith=list(
                                    "dep",
                                    "blocks",
                                    "refLevels",
                                    "ciWidthEmm",
                                    "emmWeights",
                                    "emmPlotData",
                                    "emmPlotError")))
                            self$add(jmvcore::Table$new(
                                options=options,
                                name="emmTable",
                                title="",
                                visible="(emmTables)",
                                columns=list(),
                                clearWith=list(
                                    "dep",
                                    "blocks",
                                    "refLevels",
                                    "ciWidthEmm",
                                    "emmWeights")))}))$new(options=options)))},
        .setModel=function(x) private$..model <- x))

anovaBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "anovaBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'anova',
                version = c(2,0,0),
                options = options,
                results = anovaResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE)
        }))

#' ANOVA
#'
#' Analysis of Variance
#'
#' @examples
#' data('ToothGrowth')
#'
#' anova(ToothGrowth, dep = 'len', factors = c('dose', 'supp'))
#'
#' #
#' #  ANOVA
#' #
#' #  ANOVA
#' #  -----------------------------------------------------------------------
#' #                 Sum of Squares    df    Mean Square    F        p
#' #  -----------------------------------------------------------------------
#' #    dose                   2426     2         1213.2    92.00    < .001
#' #    supp                    205     1          205.4    15.57    < .001
#' #    dose:supp               108     2           54.2     4.11     0.022
#' #    Residuals               712    54           13.2
#' #  -----------------------------------------------------------------------
#' #
#'
#' @param data the data as a data frame
#' @param dep a string naming the dependent variable from \code{data},
#'   variable must be numeric
#' @param factors a vector of strings naming the fixed factors from
#'   \code{data}
#' @param modelTerms a list of character vectors describing the terms to go
#'   into the model
#' @param ss \code{'1'}, \code{'2'} or \code{'3'} (default), the sum of
#'   squares to use
#' @param effectSize one or more of \code{'eta'}, \code{'partEta'}, or
#'   \code{'omega'}; use eta², partial eta², and omega² effect sizes,
#'   respectively
#' @param contrasts a list of lists specifying the factor and type of contrast
#'   to use, one of \code{'deviation'}, \code{'simple'}, \code{'difference'},
#'   \code{'helmert'}, \code{'repeated'} or \code{'polynomial'}
#' @param postHoc a list of terms to perform post-hoc tests on
#' @param postHocCorr one or more of \code{'none'}, \code{'tukey'},
#'   \code{'scheffe'}, \code{'bonf'}, or \code{'holm'}; provide no, Tukey,
#'   Scheffe, Bonferroni, and Holm Post Hoc corrections respectively
#' @param homo \code{TRUE} or \code{FALSE} (default), perform homogeneity
#'   tests
#' @param qq \code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of
#'   residuals
#' @param emMeans a list of lists specifying the variables for which the
#'   estimated marginal means need to be calculate. Supports up to three
#'   variables per term.
#' @param ciWidthEmm a number between 50 and 99.9 (default: 95) specifying the
#'   confidence interval width for the estimated marginal means
#' @param emmPlots \code{TRUE} (default) or \code{FALSE}, provide estimated
#'   marginal means plots
#' @param emmPlotData \code{TRUE} or \code{FALSE} (default), plot the data on
#'   top of the marginal means
#' @param emmPlotError \code{'none'}, \code{'ci'} (default), or \code{'se'}.
#'   Use no error bars, use confidence intervals, or use standard errors on the
#'   marginal mean plots, respectively
#' @param emmTables \code{TRUE} or \code{FALSE} (default), provide estimated
#'   marginal means tables
#' @param emmWeights \code{TRUE} (default) or \code{FALSE}, weigh each cell
#'   equally or weigh them according to the cell frequency
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$main} \tab \tab \tab \tab \tab a table of ANOVA results \cr
#'   \code{results$model} \tab \tab \tab \tab \tab The underlying \code{aov} object \cr
#'   \code{results$assump$homo} \tab \tab \tab \tab \tab a table of homogeneity tests \cr
#'   \code{results$assump$qq} \tab \tab \tab \tab \tab a q-q plot \cr
#'   \code{results$contrasts} \tab \tab \tab \tab \tab an array of contrasts tables \cr
#'   \code{results$postHoc} \tab \tab \tab \tab \tab an array of post-hoc tables \cr
#'   \code{results$emm} \tab \tab \tab \tab \tab an array of the estimated marginal means plots + tables \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$main$asDF}
#'
#' \code{as.data.frame(results$main)}
#'
#' @export
anova <- function(
    data,
    dep,
    factors = NULL,
    modelTerms = NULL,
    ss = "3",
    effectSize = NULL,
    contrasts = NULL,
    postHoc = NULL,
    postHocCorr = list(
                "tukey"),
    homo = FALSE,
    qq = FALSE,
    emMeans = list(
                list()),
    ciWidthEmm = 95,
    emmPlots = TRUE,
    emmPlotData = FALSE,
    emmPlotError = "ci",
    emmTables = FALSE,
    emmWeights = TRUE) {

    if ( ! requireNamespace('jmvcore'))
        stop('anova requires jmvcore to be installed (restart may be required)')

    if (missing(data))
        data <- jmvcore:::marshalData(
            parent.frame(),
            `if`( ! missing(dep), dep, NULL),
            `if`( ! missing(factors), factors, NULL))

    options <- anovaOptions$new(
        dep = dep,
        factors = factors,
        modelTerms = modelTerms,
        ss = ss,
        effectSize = effectSize,
        contrasts = contrasts,
        postHoc = postHoc,
        postHocCorr = postHocCorr,
        homo = homo,
        qq = qq,
        emMeans = emMeans,
        ciWidthEmm = ciWidthEmm,
        emmPlots = emmPlots,
        emmPlotData = emmPlotData,
        emmPlotError = emmPlotError,
        emmTables = emmTables,
        emmWeights = emmWeights)

    results <- anovaResults$new(
        options = options)

    analysis <- anovaClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
