
# This file is automatically generated, you probably don't want to edit this

ttestOneSOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "ttestOneSOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vars = NULL,
            students = TRUE,
            bf = FALSE,
            bfPrior = 0.707,
            wilcoxon = FALSE,
            testValue = 0,
            hypothesis = "dt",
            norm = FALSE,
            qq = FALSE,
            meanDiff = FALSE,
            effectSize = FALSE,
            ci = FALSE,
            ciWidth = 95,
            desc = FALSE,
            plots = FALSE,
            miss = "perAnalysis",
            mann = FALSE, ...) {

            super$initialize(
                package='jmv',
                name='ttestOneS',
                requiresData=TRUE,
                ...)

            private$..vars <- jmvcore::OptionVariables$new(
                "vars",
                vars,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "numeric"),
                rejectInf=FALSE)
            private$..students <- jmvcore::OptionBool$new(
                "students",
                students,
                default=TRUE)
            private$..bf <- jmvcore::OptionBool$new(
                "bf",
                bf,
                default=FALSE)
            private$..bfPrior <- jmvcore::OptionNumber$new(
                "bfPrior",
                bfPrior,
                default=0.707,
                min=0.5,
                max=2)
            private$..wilcoxon <- jmvcore::OptionBool$new(
                "wilcoxon",
                wilcoxon,
                default=FALSE)
            private$..testValue <- jmvcore::OptionNumber$new(
                "testValue",
                testValue,
                default=0)
            private$..hypothesis <- jmvcore::OptionList$new(
                "hypothesis",
                hypothesis,
                options=list(
                    "dt",
                    "gt",
                    "lt"),
                default="dt")
            private$..norm <- jmvcore::OptionBool$new(
                "norm",
                norm,
                default=FALSE)
            private$..qq <- jmvcore::OptionBool$new(
                "qq",
                qq,
                default=FALSE)
            private$..meanDiff <- jmvcore::OptionBool$new(
                "meanDiff",
                meanDiff,
                default=FALSE)
            private$..effectSize <- jmvcore::OptionBool$new(
                "effectSize",
                effectSize,
                default=FALSE)
            private$..ci <- jmvcore::OptionBool$new(
                "ci",
                ci,
                default=FALSE)
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
            private$..desc <- jmvcore::OptionBool$new(
                "desc",
                desc,
                default=FALSE)
            private$..plots <- jmvcore::OptionBool$new(
                "plots",
                plots,
                default=FALSE)
            private$..miss <- jmvcore::OptionList$new(
                "miss",
                miss,
                options=list(
                    "perAnalysis",
                    "listwise"),
                default="perAnalysis")
            private$..mann <- jmvcore::OptionBool$new(
                "mann",
                mann,
                default=FALSE,
                hidden=TRUE)

            self$.addOption(private$..vars)
            self$.addOption(private$..students)
            self$.addOption(private$..bf)
            self$.addOption(private$..bfPrior)
            self$.addOption(private$..wilcoxon)
            self$.addOption(private$..testValue)
            self$.addOption(private$..hypothesis)
            self$.addOption(private$..norm)
            self$.addOption(private$..qq)
            self$.addOption(private$..meanDiff)
            self$.addOption(private$..effectSize)
            self$.addOption(private$..ci)
            self$.addOption(private$..ciWidth)
            self$.addOption(private$..desc)
            self$.addOption(private$..plots)
            self$.addOption(private$..miss)
            self$.addOption(private$..mann)
        }),
    active = list(
        vars = function() private$..vars$value,
        students = function() private$..students$value,
        bf = function() private$..bf$value,
        bfPrior = function() private$..bfPrior$value,
        wilcoxon = function() private$..wilcoxon$value,
        testValue = function() private$..testValue$value,
        hypothesis = function() private$..hypothesis$value,
        norm = function() private$..norm$value,
        qq = function() private$..qq$value,
        meanDiff = function() private$..meanDiff$value,
        effectSize = function() private$..effectSize$value,
        ci = function() private$..ci$value,
        ciWidth = function() private$..ciWidth$value,
        desc = function() private$..desc$value,
        plots = function() private$..plots$value,
        miss = function() private$..miss$value,
        mann = function() private$..mann$value),
    private = list(
        ..vars = NA,
        ..students = NA,
        ..bf = NA,
        ..bfPrior = NA,
        ..wilcoxon = NA,
        ..testValue = NA,
        ..hypothesis = NA,
        ..norm = NA,
        ..qq = NA,
        ..meanDiff = NA,
        ..effectSize = NA,
        ..ci = NA,
        ..ciWidth = NA,
        ..desc = NA,
        ..plots = NA,
        ..miss = NA,
        ..mann = NA)
)

ttestOneSResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        ttest = function() private$.items[["ttest"]],
        normality = function() private$.items[["normality"]],
        descriptives = function() private$.items[["descriptives"]],
        plots = function() private$.items[["plots"]],
        qq = function() private$.items[["qq"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="One Sample T-Test")
            self$add(jmvcore::Table$new(
                options=options,
                name="ttest",
                title="One Sample T-Test",
                rows="(vars)",
                clearWith=list(
                    "hypothesis",
                    "testValue",
                    "miss",
                    "bfPrior",
                    "ciWidth"),
                columns=list(
                    list(
                        `name`="var[stud]", 
                        `title`="", 
                        `content`="($key)", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(students)"),
                    list(
                        `name`="name[stud]", 
                        `title`="", 
                        `content`="Student's t", 
                        `type`="text", 
                        `visible`="(students)"),
                    list(
                        `name`="stat[stud]", 
                        `title`="statistic", 
                        `type`="number", 
                        `visible`="(students)"),
                    list(
                        `name`="err[stud]", 
                        `title`="error %", 
                        `type`="number", 
                        `visible`="(students && bf)", 
                        `content`=""),
                    list(
                        `name`="df[stud]", 
                        `title`="df", 
                        `type`="number", 
                        `visible`="(students)"),
                    list(
                        `name`="p[stud]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(students)"),
                    list(
                        `name`="md[stud]", 
                        `title`="Mean difference", 
                        `type`="number", 
                        `visible`="(meanDiff && students)"),
                    list(
                        `name`="cil[stud]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ci && students)"),
                    list(
                        `name`="ciu[stud]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ci && students)"),
                    list(
                        `name`="es[stud]", 
                        `title`="Cohen's d", 
                        `type`="number", 
                        `visible`="(effectSize && students)"),
                    list(
                        `name`="var[bf]", 
                        `title`="", 
                        `content`="($key)", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(bf)"),
                    list(
                        `name`="name[bf]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Bayes factor\u2081\u2080", 
                        `visible`="(bf)"),
                    list(
                        `name`="stat[bf]", 
                        `title`="statistic", 
                        `type`="number", 
                        `visible`="(bf)"),
                    list(
                        `name`="err[bf]", 
                        `title`="\u00B1%", 
                        `type`="number", 
                        `visible`="(bf)"),
                    list(
                        `name`="df[bf]", 
                        `title`="df", 
                        `type`="number", 
                        `visible`="(bf)", 
                        `content`=""),
                    list(
                        `name`="p[bf]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(bf)", 
                        `content`=""),
                    list(
                        `name`="md[bf]", 
                        `title`="Mean difference", 
                        `type`="number", 
                        `visible`="(meanDiff && bf)", 
                        `content`=""),
                    list(
                        `name`="sed[bf]", 
                        `title`="SE difference", 
                        `type`="number", 
                        `visible`="(meanDiff && bf)", 
                        `content`=""),
                    list(
                        `name`="cil[bf]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ci && bf)", 
                        `content`=""),
                    list(
                        `name`="ciu[bf]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ci && bf)", 
                        `content`=""),
                    list(
                        `name`="es[bf]", 
                        `title`="Cohen's d", 
                        `type`="number", 
                        `visible`="(effectSize && bf)", 
                        `content`=""),
                    list(
                        `name`="var[wilc]", 
                        `title`="", 
                        `content`="($key)", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(wilcoxon || mann)"),
                    list(
                        `name`="name[wilc]", 
                        `title`="", 
                        `content`="Wilcoxon W", 
                        `type`="text", 
                        `visible`="(wilcoxon || mann)"),
                    list(
                        `name`="stat[wilc]", 
                        `title`="stat", 
                        `type`="number", 
                        `visible`="(wilcoxon || mann)"),
                    list(
                        `name`="err[wilc]", 
                        `title`="\u00B1%", 
                        `type`="number", 
                        `visible`="(bf && (wilcoxon || mann))", 
                        `content`=""),
                    list(
                        `name`="p[wilc]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(wilcoxon || mann)"),
                    list(
                        `name`="md[wilc]", 
                        `title`="Mean difference", 
                        `type`="number", 
                        `visible`="(meanDiff && (wilcoxon || mann))"),
                    list(
                        `name`="cil[wilc]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ci && (wilcoxon || mann))"),
                    list(
                        `name`="ciu[wilc]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ci && (wilcoxon || mann))"),
                    list(
                        `name`="es[wilc]", 
                        `title`="Cohen's d", 
                        `type`="number", 
                        `visible`="(effectSize && (wilcoxon || mann))"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="normality",
                title="Test of Normality (Shapiro-Wilk)",
                visible="(norm)",
                rows="(vars)",
                notes=list(
                    `p`="A low p-value suggests a violation of the assumption of normality"),
                clearWith=list(
                    "miss"),
                columns=list(
                    list(
                        `name`="name", 
                        `title`="", 
                        `content`="($key)", 
                        `type`="text"),
                    list(
                        `name`="w", 
                        `title`="W", 
                        `type`="number"),
                    list(
                        `name`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="descriptives",
                title="Descriptives",
                visible="(desc)",
                rows="(vars)",
                clearWith=list(
                    "miss"),
                columns=list(
                    list(
                        `name`="name", 
                        `title`="", 
                        `content`="($key)", 
                        `type`="text"),
                    list(
                        `name`="num", 
                        `title`="N", 
                        `type`="number"),
                    list(
                        `name`="mean", 
                        `title`="Mean", 
                        `type`="number"),
                    list(
                        `name`="median", 
                        `title`="Median", 
                        `type`="number"),
                    list(
                        `name`="sd", 
                        `title`="SD", 
                        `type`="number"),
                    list(
                        `name`="se", 
                        `title`="SE", 
                        `type`="number"))))
            self$add(jmvcore::Image$new(
                options=options,
                name="plots",
                title="Plots",
                visible="(plots)",
                renderFun=".desc",
                clearWith=list(
                    "vars",
                    "miss")))
            self$add(jmvcore::Array$new(
                options=options,
                name="qq",
                title="Q-Q plots",
                visible="(qq)",
                items="(vars)",
                clearWith=list(
                    "miss"),
                template=jmvcore::Image$new(
                    options=options,
                    width=350,
                    height=300,
                    requiresData=TRUE,
                    renderFun=".qq",
                    clearWith=list())))}))

ttestOneSBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "ttestOneSBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'ttestOneS',
                version = c(1,0,0),
                options = options,
                results = ttestOneSResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE)
        }))

#' One Sample T-Test
#'
#' 
#'
#' @examples
#' data('ToothGrowth')
#'
#' ttestOneS(ToothGrowth, vars = c('len', 'dose'))
#'
#' #
#' #  ONE SAMPLE T-TEST
#' #
#' #  One Sample T-Test
#' #  ------------------------------------------------------
#' #                           statistic    df      p
#' #  ------------------------------------------------------
#' #    len     Student's t         19.1    59.0    < .001
#' #    dose    Student's t         14.4    59.0    < .001
#' #  ------------------------------------------------------
#' #
#'
#' @param data the data as a data frame
#' @param vars a vector of strings naming the variables of interest in
#'   \code{data}
#' @param students \code{TRUE} (default) or \code{FALSE}, perform Student's
#'   t-tests
#' @param bf \code{TRUE} or \code{FALSE} (default), provide Bayes factors
#' @param bfPrior a number between 0.5 and 2 (default 0.707), the prior width
#'   to use in calculating Bayes factors
#' @param wilcoxon \code{TRUE} or \code{FALSE} (default), perform Wilcoxon
#'   signed rank tests
#' @param testValue a number specifying the value of the null hypothesis
#' @param hypothesis \code{'dt'} (default), \code{'gt'} or \code{'lt'}, the
#'   alternative hypothesis; different to \code{testValue}, greater than
#'   \code{testValue}, and less than \code{testValue} respectively
#' @param norm \code{TRUE} or \code{FALSE} (default), perform Shapiro-wilk
#'   tests of normality
#' @param qq \code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of
#'   residuals
#' @param meanDiff \code{TRUE} or \code{FALSE} (default), provide means and
#'   standard deviations
#' @param effectSize \code{TRUE} or \code{FALSE} (default), provide effect
#'   sizes
#' @param ci \code{TRUE} or \code{FALSE} (default), provide confidence
#'   intervals
#' @param ciWidth a number between 50 and 99.9 (default: 95), the width of
#'   confidence intervals
#' @param desc \code{TRUE} or \code{FALSE} (default), provide descriptive
#'   statistics
#' @param plots \code{TRUE} or \code{FALSE} (default), provide descriptive
#'   plots
#' @param miss \code{'perAnalysis'} or \code{'listwise'}, how to handle
#'   missing values; \code{'perAnalysis'} excludes missing values for individual
#'   dependent variables, \code{'listwise'} excludes a row from all analyses if
#'   one of its entries is missing.
#' @param mann deprecated
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$ttest} \tab \tab \tab \tab \tab a table containing the t-test results \cr
#'   \code{results$normality} \tab \tab \tab \tab \tab a table containing the normality test results \cr
#'   \code{results$descriptives} \tab \tab \tab \tab \tab a table containing the descriptives \cr
#'   \code{results$plots} \tab \tab \tab \tab \tab an image of the descriptive plots \cr
#'   \code{results$qq} \tab \tab \tab \tab \tab an array of Q-Q plots \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$ttest$asDF}
#'
#' \code{as.data.frame(results$ttest)}
#'
#' @export
ttestOneS <- function(
    data,
    vars,
    students = TRUE,
    bf = FALSE,
    bfPrior = 0.707,
    wilcoxon = FALSE,
    testValue = 0,
    hypothesis = "dt",
    norm = FALSE,
    qq = FALSE,
    meanDiff = FALSE,
    effectSize = FALSE,
    ci = FALSE,
    ciWidth = 95,
    desc = FALSE,
    plots = FALSE,
    miss = "perAnalysis",
    mann = FALSE) {

    if ( ! requireNamespace('jmvcore'))
        stop('ttestOneS requires jmvcore to be installed (restart may be required)')

    if (missing(data))
        data <- jmvcore:::marshalData(
            parent.frame(),
            `if`( ! missing(vars), vars, NULL))

    options <- ttestOneSOptions$new(
        vars = vars,
        students = students,
        bf = bf,
        bfPrior = bfPrior,
        wilcoxon = wilcoxon,
        testValue = testValue,
        hypothesis = hypothesis,
        norm = norm,
        qq = qq,
        meanDiff = meanDiff,
        effectSize = effectSize,
        ci = ci,
        ciWidth = ciWidth,
        desc = desc,
        plots = plots,
        miss = miss,
        mann = mann)

    results <- ttestOneSResults$new(
        options = options)

    analysis <- ttestOneSClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
