% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dm.addSummaryStatistic}
\alias{dm.addSummaryStatistic}
\title{Adds a summary statistic to the model.}
\usage{
dm.addSummaryStatistic(dm, sum.stat, group = 0)
}
\arguments{
\item{dm}{The demographic model to which a summary statistic should be added.}

\item{sum.stat}{The summary statistic to add. Use the names mentioned above.}

\item{group}{If given, the summary statistic is only calculated for a
given group of loci.}
}
\value{
The model with a summary statistic added.
}
\description{
This summary statistic will the be calulated for each simualtion
and returned by the simSumStats function.
}
\details{
Avaible summary statistics are
'jsfs' - calculates the Joint Site Frequency Spectrum
'seg.sites' - return the simulated segregating sites as matrix
'file' - returns a file in which the simulation output is written
'fpc' - calculates the Four-Gamete-Condition based statistic
}
\examples{
dm <- dm.createThetaTauModel(c(15, 20), 100)
dm <- dm.addSummaryStatistic(dm, 'seg.sites')
str(dm.simSumStats(dm, c(1, 5)))
}

