% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Jaatha.refinedSearch}
\alias{Jaatha.refinedSearch}
\title{Iterative search for the maximum composite likelihood parameters}
\usage{
Jaatha.refinedSearch(jaatha, best.start.pos = 2,
  sim = length(getParNames(jaatha)) * 25, sim.final = min(sim, 100),
  epsilon = NULL, half.block.size = 0.025, weight = NULL,
  max.steps = 200, rerun = FALSE)
}
\arguments{
\item{jaatha}{The Jaatha settings (create with \code{\link{Jaatha.initialize}})}

\item{best.start.pos}{This is the number of best starting positions
found in the initial search that we will use. Jaatha runs a separate
search starting from each of this points.}

\item{sim}{The number of simulations that are performed in each step}

\item{sim.final}{The number of simulations that are performed after the search to estimate the
composite log likelihood. If not specified, the value of \code{sim} will be used}

\item{epsilon}{Obsolete. Has no effect anymore and will be remove on next
major release.}

\item{half.block.size}{The size of the new block that is created around a new maximum.}

\item{weight}{Obsolete. Has no effect anymore and will be remove on next
major release.}

\item{max.steps}{The search will stop at this number of steps if not stopped
before (see \code{epsilon}).}

\item{rerun}{You can repeat a previously done refined search in Jaatha.
       Do do so, just call the refined search function with the jaatha
       object result of the first refined search and set rerun to 'TRUE'.}
}
\value{
An Jaatha object. The found values are written to the slot likelihood.table.
}
\description{
This function searches for the parameter combination with the highest
composite likelihood. Therefore it iteratively searches the area (=block)
around the last found value for a new maximum using simulations and a
generalized linear model.
}

