% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/between.R
\name{iv_between}
\alias{iv_between}
\title{Detect when a vector falls between an iv}
\usage{
iv_between(needles, haystack, ..., missing = "equals")
}
\arguments{
\item{needles}{\verb{[vector, iv]}

\code{needles} should be a vector and \code{haystack} should be an iv. \code{needles}
should have the same type as the start/end components of \code{haystack}.
\itemize{
\item Each element of \code{needles} represents the value to search for.
\item \code{haystack} represents the intervals to search in.
}}

\item{haystack}{\verb{[vector, iv]}

\code{needles} should be a vector and \code{haystack} should be an iv. \code{needles}
should have the same type as the start/end components of \code{haystack}.
\itemize{
\item Each element of \code{needles} represents the value to search for.
\item \code{haystack} represents the intervals to search in.
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{missing}{\verb{[logical(1) / "equals" / "error"]}

Handling of missing values in \code{needles}.
\itemize{
\item \code{"equals"} considers missing values in \code{needles} as exactly equal
to missing intervals in \code{haystack} when determining if there is a
matching relationship between them. Matched missing values in
\code{needles} result in a \code{TRUE} value in the result, and unmatched missing
values result in a \code{FALSE} value.
\item \code{"error"} throws an error if any values in \code{needles} are missing.
\item If a single logical value is provided, this represents the value returned
in the result for values in \code{needles} that are missing. You can force
missing values to be unmatched by setting this to \code{FALSE}, and you
can force them to be propagated by setting this to \code{NA}.
}}
}
\value{
A logical vector the same size as \code{needles}.
}
\description{
\code{iv_between()} detects when \code{needles}, a vector, falls between the
bounds of \code{haystack}, an iv. It works similar to \link[base:match]{base::\%in\%}, where
\code{needles[i]} checks for a match in all of \code{haystack}.

This function returns a logical vector the same size as \code{needles} containing
\code{TRUE} if the value in \code{needles} is between any interval in \code{haystack} and
\code{FALSE} otherwise.
}
\examples{
x <- as.Date(c("2019-01-05", "2019-01-10", "2019-01-07", "2019-01-20"))

y <- iv_pairs(
  as.Date(c("2019-01-01", "2019-01-03")),
  as.Date(c("2019-01-04", "2019-01-08")),
  as.Date(c("2019-01-07", "2019-01-09")),
  as.Date(c("2019-01-10", "2019-01-20")),
  as.Date(c("2019-01-15", "2019-01-20"))
)

x
y

# Detect if any location where `x` is between the intervals in `y`
iv_between(x, y)

# ---------------------------------------------------------------------------

a <- c(1, NA)
b <- iv(c(NA, NA), c(NA, NA))

# By default, missing values in `needles` are treated as being exactly
# equal to missing intervals in `haystack`, so the missing value in `a` is
# considered between the missing interval in `b`.
iv_between(a, b)

# If you'd like to propagate missing values, set `missing = NA`
iv_between(a, b, missing = NA)

# If you'd like missing values to be treated as unmatched, set
# `missing = FALSE`
iv_between(a, b, missing = FALSE)
}
\seealso{
\link[=relation-locate]{Locating relationships}

\link[=iv_locate_between]{Locating where a vector falls between an iv}

\link[=iv_pairwise_between]{Pairwise detect when a vector falls between an iv}
}
