% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.r
\name{dplyr_select_style}
\alias{dplyr_select_style}
\title{Select-style helpers from dplyr}
\description{
Several arguments in \code{ipumsr} allow syntax for selecting variables
based on dplyr's \code{\link[dplyr]{select}} function. See details for more information.
}
\details{
There are 3 broad categories of methods for specifying arguments for these select-style
parameters.
\itemize{
 \item{"Character Vector"}{A character vector of names (such as \code{c("var1", "var2", "var3")})}
 \item{"'Bare' Vector"}{A vector of 'bare' names (such as \code{c(var1, var2, var3)})}
 \item{"Helper Functions"}{Helper functions from \code{dplyr::select} such as
    \code{starts_with()}, \code{contains} and others.}
}
}
\examples{
# For microdata, use this syntax to load variables
# Load 3 variables by name
cps_file <- ipums_example("cps_00006.xml")
data <- read_ipums_micro(cps_file, vars = c("YEAR", "MONTH", "PERNUM"))

# Load same 3 variables using bare names
data <- read_ipums_micro(cps_file, vars = c(YEAR, MONTH, PERNUM))

# Use helper functions to load all variables that start with "WT"
data <- read_ipums_micro(cps_file, vars = starts_with("WT"))

# Use bare names and helper function to load YEAR, MONTH and all variables with 'INC' in name
data <- read_ipums_micro(cps_file, vars = c(YEAR, MONTH, contains("INC")))

# For geographic extracts, `data_layer` and `shape_layer` arguments use the same conventions
# to select file names from within zip files.
# (This extract only contains 1 type of file, but some have multiple)
csv_file <- ipums_example("nhgis0008_csv.zip")
data <- read_nhgis(
  csv_file,
  data_layer = contains("pmsa")
)

}
