% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go_insane.R
\name{go_insane}
\alias{go_insane}
\title{Run the Shiny Application}
\usage{
go_insane(
  demo = FALSE,
  port = getOption("shiny.port"),
  launch.browser = getOption("shiny.launch.browser", interactive()),
  host = getOption("shiny.host", "127.0.0.1"),
  workerId = "",
  quiet = FALSE,
  display.mode = c("auto", "normal", "showcase"),
  test.mode = getOption("shiny.testmode", FALSE)
)
}
\arguments{
\item{demo}{[\link{logical}] A logical indicating if examples spreadsheets should be copied in the app.}

\item{port}{The TCP port that the application should listen on. If the
\code{port} is not specified, and the \code{shiny.port} option is set (with
\code{options(shiny.port = XX)}), then that port will be used. Otherwise,
use a random port.}

\item{launch.browser}{If true, the system's default web browser will be
launched automatically after the app is started. Defaults to true in
interactive sessions only. This value of this parameter can also be a
function to call with the application's URL.}

\item{host}{The IPv4 address that the application should listen on. Defaults
to the \code{shiny.host} option, if set, or \code{"127.0.0.1"} if not. See
Details.}

\item{workerId}{Can generally be ignored. Exists to help some editions of
Shiny Server Pro route requests to the correct process.}

\item{quiet}{Should Shiny status messages be shown? Defaults to FALSE.}

\item{display.mode}{The mode in which to display the application. If set to
the value \code{"showcase"}, shows application code and metadata from a
\code{DESCRIPTION} file in the application directory alongside the
application. If set to \code{"normal"}, displays the application normally.
Defaults to \code{"auto"}, which displays the application in the mode given
in its \code{DESCRIPTION} file, if any.}

\item{test.mode}{Should the application be launched in test mode? This is
only used for recording or running automated tests. Defaults to the
\code{shiny.testmode} option, or FALSE if the option is not set.}
}
\description{
Runs a Shiny application. This function normally does not return;
interrupt R to stop the application (usually by pressing Ctrl+C or Esc).
}
\examples{

if (interactive()) {
  library(insane)
  # Must be run in an interactive R session!
  go_insane()
}

}
