% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReadModflowBinary.R
\name{ReadModflowBinary}
\alias{ReadModflowBinary}
\title{Read MODFLOW Binary File}
\usage{
ReadModflowBinary(path, data.type = c("array", "flow"),
  endian = c("little", "big"), rm.totim.0 = FALSE)
}
\arguments{
\item{path}{'character' string.
Path to a MODFLOW binary file.}

\item{data.type}{'character' string.
Description of how the data were saved.
Specify \code{"array"} for array data (such as hydraulic heads or drawdowns) and
\code{"flow"} for cell-by-cell flow data (budget data).}

\item{endian}{'character' string.
Endian-ness (or byte-order) of the binary file.}

\item{rm.totim.0}{'logical' flag.
Whether data associated with the stress period at time zero should be removed.}
}
\value{
A 'list' of length equal to the
  number of times data were written to the binary file.
  List components are as follows:
  \describe{
    \item{d}{matrix of values.
      The matrix dimensions typically coincide with the horizontal model grid.
      The exception is for flow data (\code{data.type = "flow"}) when the
      cell-by-cell budget file is saved using the \emph{\bold{"COMPACT BUDGET"}} output option;
      for this case, matrix columns are: cell index (\code{"icell"}),
      model-grid layer (\code{"layer"}), model-grid row (\code{"row"}),
      model-grid column (\code{"column"}), cell-by-cell flow (\code{"flow"}),
      and any auxiliary variables saved using the \emph{\bold{"AUXILIARY"}} output option.}
    \item{kstp}{time step}
    \item{kper}{stress period}
    \item{desc}{description of data-type, such as "wells".}
    \item{layer}{model-grid layer}
    \item{delt}{time-step size}
    \item{pertim}{elapsed time in the current stress period.}
    \item{totim}{total elapsed time}
  }
  The layer component (layer) and time components (delt, pertim, totim) are only available
  for flow data when the cell-by-cell budget file is saved using the
  \emph{\bold{"COMPACT BUDGET"}} output option.
}
\description{
Read binary files output from \href{https://www.usgs.gov/mission-areas/water-resources/science/modflow-and-related-programs}{MODFLOW}-based models,
the U.S. Geological Survey's three-dimensional finite-difference groundwater model.
}
\examples{
path <- system.file("extdata", "ex.hds", package = "inlmisc")
heads <- ReadModflowBinary(path, "array")
image(heads[[1]]$d)
str(heads[[1]])

path <- system.file("extdata", "ex.bud", package = "inlmisc")
budget <- ReadModflowBinary(path, "flow")
image(budget[[1]]$d)
str(budget[[1]])
str(budget[[11]])

}
\seealso{
\code{\link{SummariseBudget}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{IO}
