% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BumpDisconnectCells.R
\name{BumpDisconnectCells}
\alias{BumpDisconnectCells}
\title{Adjustment for Vertically Disconnected Cells}
\usage{
BumpDisconnectCells(rs, min.overlap = 2, bump.by = 0.1,
  max.itr = 10000)
}
\arguments{
\item{rs}{'Raster*'.
A collection of two raster layers, the first and second layers represent
the upper and lower surface of a 3D model layer.}

\item{min.overlap}{'numeric'.
Minimum vertical overlap between horizontally adjacent model cells.}

\item{bump.by}{'numeric'.
Amount to decrease a cell value by during each iteration of the algorithm.}

\item{max.itr}{'numeric'.
Maximum number of iterations.}
}
\value{
Returns a 'RasterLayer' that can be added to \code{rs[[2]]} to ensure connectivity between model layer cells.
  Cell values in the returned raster grid represent vertical adjustments.
}
\description{
Given upper and lower surfaces (raster layers) of a three-dimensional (3D) model layer,
this function incrementally decreases lower cell values until
a minimum vertical overlap between adjacent model cells is achieved.
}
\details{
During each iteration of the algorithm:
  (1) Cells are identified that violate the minimum vertical overlap between adjacent cells; that is,
      the bottom of cell \emph{i} is greater than or equal to the top of an adjacent cell \emph{j} minus the
      minimum overlap specified by the \code{min.overlap} argument.
  (2) For cells violating the minimum vertical overlap, lower raster layer (\code{rs[[2]]}) values are
      decreased by the value specified in the \code{bump.by} argument.
}
\examples{
set.seed(0)
r_top <- raster::raster(ncols = 10, nrows = 10)
r_bot <- raster::raster(ncols = 10, nrows = 10)
r_top[] <- rnorm(raster::ncell(r_top), mean = 12)
r_bot[] <- rnorm(raster::ncell(r_bot), mean = 10)
rs <- raster::stack(r_top, r_bot)
r <- BumpDisconnectCells(rs, min.overlap = 0.1)
raster::plot(r, col = GetTolColors(255, reverse = TRUE))
summary(r[])

r_bot_new <- r_bot + r

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{utilities}
