% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BumpDisconnectCells.R
\name{BumpDisconnectCells}
\alias{BumpDisconnectCells}
\title{Adjustment for Vertically Disconnected Cells}
\usage{
BumpDisconnectCells(rs, min.overlap = 2, bump.by = 0.1, max.itr = 10000)
}
\arguments{
\item{rs}{RasterStack.
A collection of two raster layers, the first and second layers represent the top and bottom of a model layer.}

\item{min.overlap}{numeric.
Minimum vertical overlap between adjacent cells.}

\item{bump.by}{numeric.
Amount to decrease a cell value by during each iteration of the algorithm.}

\item{max.itr}{numeric.
Maximum number of iterations.}
}
\value{
Returns a raster layer that can be added to \code{rs[[2]]} to ensure connectivity between cells.
  Cell values in the returned raster grid represent vertical adjustments.
}
\description{
This function decreases model cell values (such as land-surface elevations)
in the lower raster layer if they violate a minimum vertical overlap between adjacent cells.
}
\details{
During each iteration of the algorithm:
  (1) Cells are identified that violate the minimum vertical overlap between adjacent cells; that is,
      the bottom of cell i is greater than or equal to the top of an adjacent cell j minus the
      minimum overlap specified by the \code{min.overlap} argument.
  (2) For cells violating the minimum vertical overlap, lower raster layer (\code{rs[[2]]}) values are
      decreased by the value specified in the \code{bump.by} argument.
}
\examples{
set.seed(0)
r.top <- raster::raster(ncols = 10, nrows = 10)
r.bot <- raster::raster(ncols = 10, nrows = 10)
r.top[] <- rnorm(raster::ncell(r.top), mean = 12)
r.bot[] <- rnorm(raster::ncell(r.bot), mean = 10)
summary(r.top - r.bot)

r <- BumpDisconnectCells(raster::stack(r.top, r.bot), min.overlap = 0.1)
raster::plot(r.bot + r)

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{utilities}

