% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddInsetMap.R
\name{AddInsetMap}
\alias{AddInsetMap}
\title{Add Inset Map to Plot}
\usage{
AddInsetMap(p, col = c("#D8D8D8", "#BFA76F"), main.label = list(label = NA,
  adj = NULL), sub.label = list(label = NA, adj = NULL),
  loc = c("bottomleft", "topleft", "topright", "bottomright"), inset = 0.02,
  width = NULL)
}
\arguments{
\item{p}{SpatialPolygons.
Polygon describing the large map.}

\item{col}{list.
Vector of length 2 giving the colors for filling the large map polygon \code{p} and the smaller plot extent rectangle.}

\item{main.label}{list.
List with components \code{label} and \code{adj}.
The text label and position (x and y adjustment of the label) for the large map, respectively.}

\item{sub.label}{list.
Identical to the \code{main.label} argument but for the plot extent rectangle.}

\item{loc}{character.
Position of the inset map in the main plot region:
"bottomleft", "topleft", "topright", or "bottomright" to denote scale location.}

\item{inset}{numeric.
Inset distance from the margins as a fraction of the main plot region.
Defaults to 2 percent of the axis range.}

\item{width}{numeric.
Width of the inset map in inches.}
}
\value{
Used for the side-effect of a inset map drawn on the current graphics device.
}
\description{
This function can be used to add an inset map to a plot.
}
\details{
The smaller axis-aligned rectangle (relative to the larger map polygon) is defined by
  the user coordinate extent of the main plot region, see \code{par("usr")}.
}
\examples{
library(maptools)

nc <- readShapePoly(system.file("shapes/sids.shp", package = "maptools")[1],
                    proj4string=CRS("+proj=longlat +datum=NAD27"))
bb <- bbox(nc[100, ])
xlim <- extendrange(bb["x", ])
ylim <- extendrange(bb["y", ])
PlotMap(raster::crs(nc), xlim = xlim, ylim = ylim, dms.tick = TRUE)
plot(nc, add = TRUE)
AddInsetMap(nc, width = 3, main.label = list("North Carolina", adj = c(1.8, 3)),
            sub.label = list("Map area", adj = c(1.5, 0.5)), loc = "topright")

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\seealso{
\code{\link{PlotMap}}
}
\keyword{hplot}

