% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check.parameters}
\alias{check.parameters}
\title{Check input parameters}
\usage{
check.parameters(
  matrix,
  penalty,
  algorithm,
  cross_validation,
  seed,
  n_folds,
  percent_samples,
  r_threshold,
  regulators,
  targets,
  regulators_num,
  verbose,
  cores,
  ...
)
}
\arguments{
\item{matrix}{An expression matrix, cells by genes}

\item{penalty}{The type of regularization.
This can take either one of the following choices: \code{L0} and \code{L0L2}.
For high-dimensional and sparse data, such as single-cell sequencing data, \code{L0L2} is more effective.}

\item{algorithm}{The type of algorithm used to minimize the objective function.
Currently \code{CD} and \code{CDPSI} are supported.
The \code{CDPSI} algorithm may yield better results, but it also increases running time.}

\item{cross_validation}{Check whether cross validation is used.}

\item{seed}{The seed used in randomly shuffling the data for cross-validation.}

\item{n_folds}{The number of folds for cross-validation.}

\item{percent_samples}{The percent of all samples used for \code{\link{sparse.regression}}. Default set to 1.}

\item{r_threshold}{Threshold of \eqn{R^2} or correlation coefficient.}

\item{regulators}{A character vector with the regulators to consider for CSN inference.}

\item{targets}{A character vector with the targets to consider for CSN inference.}

\item{regulators_num}{The number of non-zore coefficients, this value will affect the final performance.
The maximum support size at which to terminate the regularization path.
Recommend setting this to a small fraction of min(n,p) (e.g. 0.05 * min(n,p)) as L0 regularization typically selects a small portion of non-zeros.}

\item{verbose}{Print detailed information.}

\item{cores}{Number of CPU cores used. Setting to parallelize the computation with \code{\link[foreach]{foreach}}.}

\item{...}{Parameters for other methods.}
}
\value{
Not return value, called for check input parameters
}
\description{
Check input parameters
}
