% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observe.R
\name{observe}
\alias{observe}
\title{Calculate observed statistics}
\usage{
observe(
  x,
  formula,
  response = NULL,
  explanatory = NULL,
  success = NULL,
  null = NULL,
  p = NULL,
  mu = NULL,
  med = NULL,
  sigma = NULL,
  stat = c("mean", "median", "sum", "sd", "prop", "count", "diff in means",
    "diff in medians", "diff in props", "Chisq", "F", "slope", "correlation", "t", "z",
    "ratio of props", "odds ratio"),
  order = NULL,
  ...
)
}
\arguments{
\item{x}{A data frame that can be coerced into a \link[tibble:tibble]{tibble}.}

\item{formula}{A formula with the response variable on the left and the
explanatory on the right. Alternatively, a \code{response} and \code{explanatory}
argument can be supplied.}

\item{response}{The variable name in \code{x} that will serve as the response.
This is an alternative to using the \code{formula} argument.}

\item{explanatory}{The variable name in \code{x} that will serve as the
explanatory variable. This is an alternative to using the formula argument.}

\item{success}{The level of \code{response} that will be considered a success, as
a string. Needed for inference on one proportion, a difference in
proportions, and corresponding z stats.}

\item{null}{The null hypothesis. Options include \code{"independence"} and
\code{"point"}.}

\item{p}{The true proportion of successes (a number between 0 and 1). To be used with point null hypotheses when the specified response
variable is categorical.}

\item{mu}{The true mean (any numerical value). To be used with point null
hypotheses when the specified response variable is continuous.}

\item{med}{The true median (any numerical value). To be used with point null
hypotheses when the specified response variable is continuous.}

\item{sigma}{The true standard deviation (any numerical value). To be used with
point null hypotheses.}

\item{stat}{A string giving the type of the statistic to calculate. Current
options include \code{"mean"}, \code{"median"}, \code{"sum"}, \code{"sd"}, \code{"prop"}, \code{"count"},
\code{"diff in means"}, \code{"diff in medians"}, \code{"diff in props"}, \code{"Chisq"} (or
\code{"chisq"}), \code{"F"} (or \code{"f"}), \code{"t"}, \code{"z"}, \code{"ratio of props"}, \code{"slope"},
\code{"odds ratio"}, \code{"ratio of means"}, and \code{"correlation"}. \code{infer} only
supports theoretical tests on one or two means via the \code{"t"} distribution
and one or two proportions via the \code{"z"}.}

\item{order}{A string vector of specifying the order in which the levels of
the explanatory variable should be ordered for subtraction (or division
for ratio-based statistics), where \code{order = c("first", "second")} means
\code{("first" - "second")}, or the analogue for ratios. Needed for inference on
difference in means, medians, proportions, ratios, t, and z statistics.}

\item{...}{To pass options like \code{na.rm = TRUE} into functions like
\link[base:mean]{mean()}, \link[stats:sd]{sd()}, etc. Can also be used to
supply hypothesized null values for the \code{"t"} statistic or additional
arguments to \code{\link[stats:chisq.test]{stats::chisq.test()}}.}
}
\value{
A 1-column tibble containing the calculated statistic \code{stat}.
}
\description{
This function is a wrapper that calls \code{\link[=specify]{specify()}}, \code{\link[=hypothesize]{hypothesize()}}, and
\code{\link[=calculate]{calculate()}} consecutively that can be used to calculate observed
statistics from data. \code{\link[=hypothesize]{hypothesize()}} will only be called if a point
null hypothesis parameter is supplied.

Learn more in \code{vignette("infer")}.
}
\examples{
# calculating the observed mean number of hours worked per week
gss \%>\%
  observe(hours ~ NULL, stat = "mean")

# equivalently, calculating the same statistic with the core verbs
gss \%>\%
  specify(response = hours) \%>\%
  calculate(stat = "mean")

# calculating a t statistic for hypothesized mu = 40 hours worked/week
gss \%>\%
  observe(hours ~ NULL, stat = "t", null = "point", mu = 40)

# equivalently, calculating the same statistic with the core verbs
gss \%>\%
  specify(response = hours) \%>\%
  hypothesize(null = "point", mu = 40) \%>\%
  calculate(stat = "t")

# similarly for a difference in means in age based on whether
# the respondent has a college degree
observe(
  gss,
  age ~ college,
  stat = "diff in means",
  order = c("degree", "no degree")
)

# equivalently, calculating the same statistic with the core verbs
gss \%>\%
  specify(age ~ college) \%>\%
  calculate("diff in means", order = c("degree", "no degree"))
  
# for a more in-depth explanation of how to use the infer package
\dontrun{
vignette("infer")
}

}
\seealso{
Other wrapper functions: 
\code{\link{chisq_stat}()},
\code{\link{chisq_test}()},
\code{\link{prop_test}()},
\code{\link{t_stat}()},
\code{\link{t_test}()}

Other functions for calculating observed statistics: 
\code{\link{chisq_stat}()},
\code{\link{t_stat}()}
}
\concept{functions for calculating observed statistics}
\concept{wrapper functions}
