% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_model.R
\name{simulate_model}
\alias{simulate_model}
\title{A Function to Simulate a Model from a Generic Simulation Function, with Pre and Post Processing}
\usage{
simulate_model(model, sim_fn, inits = NULL, params = NULL,
  times = NULL, as_tibble = TRUE, by_row = FALSE,
  aggregate_to = NULL, compartments = NULL, strat = NULL,
  hold_out_var = NULL, new_var = "incidence", total_pop = TRUE,
  summary_var = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{model}{A model compatible with your \code{sim_fn}.}

\item{sim_fn}{A generic simulation function, with the first argument as the model object,
a \code{params} argument, and a \code{as.data.frame} argument.}

\item{inits}{A dataframe of initial conditions, optionally a named vector can be used.}

\item{params}{A dataframe of parameters, with each parameter as a variable. Optionally a named vector can be used.}

\item{times}{A vector of the times to sample the model for, from a starting time to a final time.}

\item{as_tibble}{Logical (defaults to \code{TRUE}) indicating if the output
should be returned as a tibble, otherwise returned as the default \code{sim_fn} output.}

\item{by_row}{Logical (defaults to \code{FALSE}) indicating if inputed parameters should be inputed as a block to \code{sim_fn}
or individually. If \code{TRUE} then function will always return a tibble. Does not currently work with sim_fn that produces
multiple simulations for a single parameter set - for this scenario a block based approach or post processing is required.}

\item{aggregate_to}{A character vector or list specifying the aggregation operations to perform on the
model output. Operations are carried out in the order specified. Implemented options are; disease, demographic,
and incidence.}

\item{compartments}{A character vector or list specifying the unique compartments to aggregate. May either be
specified once for all aggregation functions or for each function separately.}

\item{strat}{The number of stratified groups in the model.}

\item{hold_out_var}{A character vector or list specifying the unique compartments that will not be aggregated. May either be
specified once for all aggregation functions or for each function separately. If compartments is set then this argument does
not need to be used.}

\item{new_var}{A character vector specifying the new variable to add when aggregating incidence.}

\item{total_pop}{A logical (defaults to \code{TRUE}) indicating if the total population should be
calculated when summarising the model demographics.}

\item{summary_var}{A logical (defaults to \code{FALSE}), specifying whether to add an additional summary variable across
all stratified levels.}

\item{verbose}{Logical (defaults to \code{FALSE}) indicating if progress information should be printed to the console.}

\item{...}{Additional arguments to pass to \code{sim_fn}}
}
\value{
Trajectories as a tibble, optionally returns the default \code{sim_fn} output.
}
\description{
A Function to Simulate a Model from a Generic Simulation Function, with Pre and Post Processing
}
\examples{

## Intialise
N = 100000
I_0 = 1
S_0 = N - I_0
R_0 = 1.1
beta = R_0

##Time for model to run over
tbegin = 0
tend = 50
times <- seq(tbegin, tend, 1)

##Vectorise input
parameters <- data.frame(beta = beta)
inits <- data.frame(S = S_0, I = I_0)

SI_sim <- simulate_model(model = SI_ode, sim_fn = solve_ode, inits, parameters, times)
}
\seealso{
aggregate_model
}
