% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{id_plot_legis}
\alias{id_plot_legis}
\title{Plot Legislator/Person and Bill/Item Ideal Points}
\usage{
id_plot_legis(object, return_data = FALSE, include = NULL,
  high_limit = 0.95, low_limit = 0.05, item_plot = NULL,
  item_plot_type = "non-inflated", text_size_label = 2,
  text_size_group = 2.5, point_size = 1, hjust_length = -0.7,
  person_labels = TRUE, group_labels = F, person_ci_alpha = 0.2,
  show_true = FALSE, group_color = TRUE, hpd_limit = 10,
  sample_persons = NULL, ...)
}
\arguments{
\item{object}{A fitted \code{idealstan} object or a named list
of \code{idealstan} objects to compare across models}

\item{return_data}{If true, the calculated legislator/bill data is returned along with the plot in a list}

\item{include}{Specify a list of person/legislator IDs to include in the plot (all others excluded)}

\item{high_limit}{The quantile (number between 0 and 1) for the high end of posterior uncertainty to show in plot}

\item{low_limit}{The quantile (number between 0 and 1) for the low end of posterior uncertainty to show in plot}

\item{item_plot}{The IDs (character vector) of the bill/item midpoints to overlay on the plot}

\item{item_plot_type}{Whether to show the \code{'non-inflated'} item/bill midpoints, 
the \code{'inflated'} item/bill midpoints, or produce plots for \code{'both'} kinds of models. 
Defaults to \code{'non-inflated'} and will only display an item/bill midpoint if one has been 
specified in \code{item_plot}.}

\item{text_size_label}{ggplot2 text size for legislator labels}

\item{text_size_group}{ggplot2 text size for group text used for points}

\item{point_size}{If \code{person_labels} and \code{group_labels} are set to \code{FALSE}, controls the size of the points plotted.}

\item{hjust_length}{horizontal adjustment of the legislator labels}

\item{person_labels}{if \code{TRUE}, use the person_id column to plot labels for the person (legislator) ideal points}

\item{group_labels}{if \code{TRUE}, use the group column to plot text markers for the group (parties) from the person/legislator data}

\item{person_ci_alpha}{The transparency level of the dot plot and confidence bars for the person ideal points}

\item{show_true}{Whether to show the true values of the legislators (if model has been simulated)}

\item{group_color}{If \code{TRUE}, give each group/bloc a different color}

\item{hpd_limit}{The greatest absolute difference in high-posterior density interval shown for any point. Useful for excluding imprecisely estimated persons/legislators from the plot. Leave NULL if you don't want to exclude any.}

\item{sample_persons}{If you don't want to use the full number of persons/legislators from the model, enter a proportion (between 0 and 1) to select
only a fraction of the persons/legislators.}

\item{...}{Other options passed on to plotting function, currently ignored}
}
\description{
This function can be used on a fitted \code{idealstan} object to plot the relative positions and 
uncertainties of legislator/persons and bills/items.
}
\details{
This plot shows the distribution of ideal points for the legislators/persons in the model. It will plot them as a vertical
dot plot with associated high-density posterior interval (can be changed 
with \code{high_limit} and \code{low_limit} options). In addition, if item/bill IDs
as a character vector is passed to the \code{item_plot} option, then an item/bill midpoint will be overlain
on the ideal point plot, showing the point at which legislators/persons are indifferent to voting/answering on the 
bill/item. Note that because this is an ideal point model, it is not possible to tell from the midpoint itself
which side will be voting which way. For that reason, the legislators/persons are colored by their votes/scores to
make it clear.

To compare across multiple \code{idealstan} models, pass a named list 
\code{list(model1=model1,model2=model2,etc)} to the \code{object} option. 
Note that these comparisons will done by individual persons/groups, so if there are a lot of 
persons/groups, consider using the \code{include} option to only compare a specific set
of persons/groups.
}
\examples{

\dontrun{

# First create data and run a model

to_idealstan <-   id_make(score_data = senate114,
outcome = 'cast_code',
person_id = 'bioname',
item_id = 'rollnumber',
group_id= 'party_code',
time_id='date',
high_val='Yes',
low_val='No',
miss_val='Absent')

sen_est <- id_estimate(senate_data,
model_type = 2,
use_vb = TRUE,
fixtype='vb_partial',
restrict_ind_high = "BARRASSO, John A.",
restrict_ind_low = "WARREN, Elizabeth")

# After running the model, we can plot 
# the results of the person/legislator ideal points

id_plot_legis(sen_est)
}

}
