% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ParentMinor}
\alias{icd9ParentMinor}
\title{get parent of an ICD-9 code}
\usage{
icd9ParentMinor(minor, invalidAction = icd9InvalidActions)
}
\arguments{
\item{minor}{character vector of 'minor' part of ICD-9 codes, i.e. that part
which falls after the decimal point, in decimal notation. (In 5 digit
notation, the 'major' part is be xyz, even when x and y are zero, thus the
last two characters represent the 'minor' part, in this case.)}

\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}
}
\value{
character vector of ICD-9 codes, one for each code given.
}
\description{
not likely to be useful for end-user, so using keyword
  \code{internal} for now.
}
\keyword{internal}

